/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.forgelike;

import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Map;
import java.util.Set;
import net.lenni0451.reflect.stream.RStream;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformLaunchPlugin;
import settingdust.preloading_tricks.forgelike.module_injector.ModuleClassLoaderInjector;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.TransformationServicesHandlerAccessor;

public abstract class PreloadingTricksTransformationService
implements ITransformationService {
    public static ClassTransformBootstrap CLASS_TRANSFORM = null;

    public static void init() {
        try {
            CodeSource codeSource = PreloadingTricksTransformationService.class.getProtectionDomain().getCodeSource();
            Path rootPath = Paths.get(codeSource.getLocation().toURI());
            for (Path path : Files.list(rootPath.resolve("libs")).filter(it -> it.getFileName().toString().endsWith(".jar")).toList()) {
                ModuleClassLoaderInjector.inject(path, IModuleLayerManager.Layer.BOOT);
            }
            if (PreloadingTricksTransformationService.class.getModule() == PreloadingTricksTransformationService.class.getClassLoader().getUnnamedModule()) {
                PreloadingTricks.LOGGER.debug("[{}] There is error in PreloadingTricksTransformationService. And it's loaded from unnamed module at the second time. Need to address by the developer. Ignore this message", (Object)"Preloading Tricks");
            } else {
                ModuleClassLoaderInjector.move(PreloadingTricksTransformationService.class, IModuleLayerManager.Layer.BOOT);
                CLASS_TRANSFORM = new ClassTransformBootstrap();
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public PreloadingTricksTransformationService() throws IOException {
        if (CLASS_TRANSFORM == null) {
            PreloadingTricks.LOGGER.debug("[{}] The `CLASS_TRANSFORM` is null. Looks like it's loaded from unnamed module at the second time. Need to address by the developer. Ignore this message", (Object)"Preloading Tricks");
            return;
        }
        PreloadingTricks.LOGGER.info("[{}] Installed", (Object)"Preloading Tricks");
        PreloadingTricksTransformationService.injectClassTransform();
    }

    private static void injectClassTransform() {
        PreloadingTricks.LOGGER.info("[{}] Inject ClassTransformLaunchPlugin", (Object)"Preloading Tricks");
        LaunchPluginHandler launchPlugins = (LaunchPluginHandler)RStream.of(Launcher.class).fields().by("launchPlugins").get((Object)Launcher.INSTANCE);
        Map plugins = (Map)RStream.of(LaunchPluginHandler.class).fields().by("plugins").get((Object)launchPlugins);
        plugins.put("class_transform", new ClassTransformLaunchPlugin(CLASS_TRANSFORM));
    }

    protected void removeSelfService() {
        Object transformationServicesHandler = LauncherAccessor.getTransformationServicesHandler();
        TransformationServicesHandlerAccessor.getServiceLookup(transformationServicesHandler).remove(this.name());
    }

    public void initialize(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }
}

