/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.lexforge;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import settingdust.preloading_tricks.api.ModManager;
import settingdust.preloading_tricks.lexforge.accessor.ModFileInfoAccessor;
import settingdust.preloading_tricks.lexforge.virtual_mod.VirtualJar;
import settingdust.preloading_tricks.lexforge.virtual_mod.VirtualModFile;

public class LexForgeModManager
implements ModManager<ModFile> {
    public final List<ModFile> mods;

    public LexForgeModManager(List<ModFile> mods) {
        this.mods = mods;
    }

    @Override
    public Collection<ModFile> all() {
        return this.mods;
    }

    @Override
    public void add(ModFile mod) {
        this.mods.add(mod);
    }

    @Override
    public void addAll(Collection<ModFile> mod) {
        this.mods.addAll(mod);
    }

    @Override
    public ModFile getById(String id) {
        return this.mods.stream().filter(mod -> mod.getModFileInfo() != null && mod.getModInfos().stream().anyMatch(it -> it.getModId().equals(id))).findFirst().orElse(null);
    }

    @Override
    public boolean remove(ModFile mod) {
        return this.mods.remove(mod);
    }

    @Override
    public boolean removeIf(Predicate<ModFile> predicate) {
        return this.mods.removeIf(predicate);
    }

    @Override
    public boolean removeAll(Collection<ModFile> modFiles) {
        return this.mods.removeAll(modFiles);
    }

    @Override
    public boolean removeById(String id) {
        return this.removeByIds(Set.of(id));
    }

    @Override
    public boolean removeByIds(Set<String> ids) {
        Iterator<ModFile> iterator = this.mods.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            IModFileInfo iModFileInfo;
            ModFile mod = iterator.next();
            if (mod.getModFileInfo() == null || mod.getModInfos().isEmpty() || !((iModFileInfo = mod.getModFileInfo()) instanceof ModFileInfo)) continue;
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            List<IModInfo> filtered = mod.getModInfos().stream().filter(it -> !ids.contains(it.getModId())).toList();
            if (filtered.isEmpty()) {
                iterator.remove();
                removed = true;
                continue;
            }
            if (filtered.size() == mod.getModInfos().size()) continue;
            removed = true;
            ModFileInfoAccessor.setMods(modFileInfo, filtered);
        }
        return removed;
    }

    @Override
    public ModFile createVirtualMod(String id, Path referencePath) {
        return new VirtualModFile(id, new VirtualJar(id, referencePath, new String[0]));
    }
}

