/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.niofs.union.UnionPath;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ResolvedModule;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.lenni0451.reflect.stream.RStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.api.PreloadingEntrypoint;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleLayerAccessor;
import settingdust.preloading_tricks.modlauncher.TransformationServiceCallback;
import settingdust.preloading_tricks.modlauncher.class_transform.ClassTransformLaunchPlugin;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleConfigurationCreator;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleInjector;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;
import settingdust.preloading_tricks.util.ServiceLoaderUtil;

public class PreloadingTricksTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger((String)"Preloading Tricks");

    public static void init() {
        try {
            CodeSource codeSource = PreloadingTricksTransformationService.class.getProtectionDomain().getCodeSource();
            UnionPath rootPath = (UnionPath)Path.of(codeSource.getLocation().toURI());
            ModuleClassLoader bootClassLoader = ModuleLayerHandlerAccessor.getModuleClassLoader(IModuleLayerManager.Layer.BOOT);
            List<Path> bootJars = Files.list(rootPath.resolve("libs/boot")).filter(it -> it.getFileName().toString().endsWith(".jar")).toList();
            LOGGER.info("Injected {} jars into BOOT layer", (Object)bootJars.size());
            LOGGER.debug("Injected jars: {}", bootJars);
            Configuration configuration = ModuleConfigurationCreator.createConfigurationFromPaths(bootJars, ModuleClassLoaderAccessor.getConfiguration(bootClassLoader));
            ModuleLayer bootLayer = LauncherAccessor.getModuleLayer(IModuleLayerManager.Layer.BOOT);
            ModuleInjector.inject(configuration, bootClassLoader, bootLayer);
            Map<String, Module> bootNameToModule = ModuleLayerAccessor.getNameToModule(bootLayer);
            Set<Module> serviceModules = LauncherAccessor.getModuleLayer(IModuleLayerManager.Layer.SERVICE).modules();
            for (ResolvedModule module : configuration.modules()) {
                for (Module serviceModule : serviceModules) {
                    ModuleAccessor.implAddReads(serviceModule, bootNameToModule.get(module.name()));
                }
            }
            ByteBuddyAgent.install();
            new ClassTransformBootstrap(ByteBuddyAgent.getInstrumentation());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public PreloadingTricksTransformationService() {
        TransformationServiceCallback.invoker.init();
        if (ClassTransformBootstrap.INSTANCE == null) {
            PreloadingTricks.LOGGER.debug("The `CLASS_TRANSFORM` is null. Looks like it's loaded from unnamed module at the second time. Need to address by the developer. Ignore this message");
            return;
        }
        PreloadingTricks.LOGGER.info("{} Installed", (Object)"Preloading Tricks");
        PreloadingTricksTransformationService.injectClassTransform();
        ClassTransformBootstrap.INSTANCE.getTransformerManager().hookInstrumentation(ByteBuddyAgent.getInstrumentation());
        ServiceLoaderUtil.loadServices(PreloadingEntrypoint.class, false);
    }

    private static void injectClassTransform() {
        PreloadingTricks.LOGGER.info("Inject ClassTransformLaunchPlugin");
        LaunchPluginHandler launchPlugins = (LaunchPluginHandler)RStream.of(Launcher.class).fields().by("launchPlugins").get((Object)Launcher.INSTANCE);
        Map plugins = (Map)RStream.of(LaunchPluginHandler.class).fields().by("plugins").get((Object)launchPlugins);
        plugins.put("class_transform", new ClassTransformLaunchPlugin());
    }

    public String name() {
        return "Preloading Tricks";
    }

    public void initialize(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    public List transformers() {
        return List.of();
    }
}

