/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.neoforge.fancy_mod_loader;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.jar.Manifest;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.api.PreloadingEntrypoint;
import settingdust.preloading_tricks.api.PreloadingTricksCallbacks;
import settingdust.preloading_tricks.forgelike.UcpClassLoaderInjector;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;
import settingdust.preloading_tricks.forgelike.specified_forge_variant.ForgeVariants;
import settingdust.preloading_tricks.neoforge.fancy_mod_loader.NeoForgeModManager;
import settingdust.preloading_tricks.util.LoaderPredicates;
import settingdust.preloading_tricks.util.ServiceLoaderUtil;

public class PreloadingTricksBootstrapper
implements GraphicsBootstrapper {
    public PreloadingTricksBootstrapper() throws URISyntaxException, IOException {
        if (!LoaderPredicates.NeoForge.test()) {
            PreloadingTricks.LOGGER.debug("Looks like we are in wrong loader. Needn't to run");
            return;
        }
        CodeSource codeSource = PreloadingTricksBootstrapper.class.getProtectionDomain().getCodeSource();
        Path rootPath = Path.of(codeSource.getLocation().toURI());
        JarContents contents = JarContents.ofPath((Path)rootPath);
        String prefix = "libs/boot";
        contents.visitContent(prefix, (relativePath, resource) -> {
            if (!relativePath.endsWith(".jar")) {
                return;
            }
            UcpClassLoaderInjector.inject(contents.getPrimaryPath(), prefix, relativePath, () -> {
                try {
                    return contents.openFile(relativePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, FMLLoader.class.getClassLoader());
        });
        ByteBuddyAgent.install();
        new ClassTransformBootstrap(ByteBuddyAgent.getInstrumentation());
        PreloadingTricks.LOGGER.info("[{}] Installed", (Object)"Preloading Tricks");
        ClassTransformBootstrap.INSTANCE.addConfig("preloading_tricks.neoforge.fml.classtransform.json");
        ClassTransformBootstrap.INSTANCE.getTransformerManager().hookInstrumentation(ByteBuddyAgent.getInstrumentation());
        ServiceLoaderUtil.loadServices(PreloadingEntrypoint.class, false);
        PreloadingTricksCallbacks.SETUP_MODS.register(_manager -> {
            if (!(_manager instanceof NeoForgeModManager)) {
                return;
            }
            NeoForgeModManager manager = (NeoForgeModManager)_manager;
            try {
                ModFile mod = manager.createVirtualMod("preloading_tricks", Path.of(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()));
                manager.add(mod);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            manager.removeIf(it -> {
                boolean shouldRemove;
                Manifest manifest = it.getContents().getManifest();
                String variantString = manifest.getMainAttributes().getValue("ForgeVariant");
                if (variantString == null) {
                    return false;
                }
                ForgeVariants variant = ForgeVariants.BY_NAME.get(variantString.toLowerCase());
                boolean bl = shouldRemove = variant != null && variant != ForgeVariants.NeoForge;
                if (shouldRemove) {
                    PreloadingTricks.LOGGER.debug("Removing {} for variant {}", (Object)it.getFilePath(), (Object)variant);
                }
                return shouldRemove;
            });
        });
    }

    public String name() {
        return "Preloading Tricks";
    }

    public void bootstrap(String[] arguments) {
    }
}

