/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.jarhandling.SecureJar;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleConfigurationCreator {
    public static Configuration createConfiguration(SecureJar jar, Configuration parentConfig) {
        String moduleName = jar.moduleDataProvider().name();
        return parentConfig.resolve((ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[]{jar}), (ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[0]), Set.of(moduleName));
    }

    public static Configuration createConfiguration(Path jarPath, Configuration parentConfig) {
        ModuleConfigurationCreator.validateJarPath(jarPath);
        return ModuleConfigurationCreator.createConfiguration(SecureJar.from((Path[])new Path[]{jarPath}), parentConfig);
    }

    public static Configuration createConfiguration(List<SecureJar> jars, Configuration parentConfig) {
        if (jars.isEmpty()) {
            return parentConfig;
        }
        Set<String> moduleNames = jars.stream().map(jar -> jar.moduleDataProvider().name()).collect(Collectors.toSet());
        return parentConfig.resolve((ModuleFinder)JarModuleFinder.of((SecureJar[])jars.toArray(new SecureJar[0])), (ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[0]), moduleNames);
    }

    public static Configuration createConfigurationFromPaths(List<Path> jarPaths, Configuration parentConfig) {
        List<SecureJar> jars = jarPaths.stream().peek(ModuleConfigurationCreator::validateJarPath).map(xva$0 -> SecureJar.from((Path[])new Path[]{xva$0})).toList();
        return ModuleConfigurationCreator.createConfiguration(jars, parentConfig);
    }

    public static Configuration createConfiguration(Configuration parentConfig, SecureJar ... jars) {
        return ModuleConfigurationCreator.createConfiguration(Arrays.asList(jars), parentConfig);
    }

    private static void validateJarPath(Path jarPath) {
        if (!jarPath.getFileName().toString().endsWith(".jar")) {
            throw new IllegalArgumentException("Path must be a jar: " + String.valueOf(jarPath));
        }
    }
}

