/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.neoforge.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Set;
import java.util.jar.Manifest;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.api.PreloadingTricksCallbacks;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;
import settingdust.preloading_tricks.forgelike.specified_forge_variant.ForgeVariants;
import settingdust.preloading_tricks.modlauncher.PreloadingTricksTransformationService;
import settingdust.preloading_tricks.neoforge.modlauncher.NeoForgeModManager;
import settingdust.preloading_tricks.util.LoaderPredicates;

public class TransformationServiceCallback
implements settingdust.preloading_tricks.modlauncher.TransformationServiceCallback {
    @Override
    public void init() {
        if (!LoaderPredicates.NeoForgeModLauncher.test()) {
            return;
        }
        PreloadingTricksTransformationService.init();
        ClassTransformBootstrap.INSTANCE.addConfig("preloading_tricks.neoforge.modlauncher.classtransform.json", PreloadingTricksTransformationService.class.getClassLoader());
        PreloadingTricksCallbacks.SETUP_MODS.register(_manager -> {
            if (!(_manager instanceof NeoForgeModManager)) {
                return;
            }
            NeoForgeModManager manager = (NeoForgeModManager)_manager;
            try {
                ModFile mod2 = manager.createVirtualMod("preloading_tricks", Path.of(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()));
                manager.add(mod2);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            manager.removeIf(it -> {
                boolean shouldRemove;
                Manifest manifest = it.getSecureJar().moduleDataProvider().getManifest();
                String variantString = manifest.getMainAttributes().getValue("ForgeVariant");
                if (variantString == null) {
                    return false;
                }
                ForgeVariants variant = ForgeVariants.BY_NAME.get(variantString.toLowerCase());
                boolean bl = shouldRemove = variant != null && variant != ForgeVariants.NeoForge;
                if (shouldRemove) {
                    PreloadingTricks.LOGGER.debug("Removing {} for variant {}", (Object)it.getFilePath(), (Object)variant);
                }
                return shouldRemove;
            });
            Set<String> packagesToRemove = Set.of("net.lenni0451.reflect");
            manager.removeIf(mod -> {
                SecureJar jar = mod.getSecureJar();
                Set<String> packages = jar.moduleDataProvider().descriptor().packages();
                boolean needRemove = packagesToRemove.stream().anyMatch(packages::contains);
                if (needRemove) {
                    PreloadingTricks.LOGGER.debug("Avoid {} from loading for packages {}", (Object)mod.getFilePath(), (Object)packagesToRemove);
                }
                return needRemove;
            });
        });
    }
}

