/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.fabric;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import settingdust.preloading_tricks.api.PreloadingTricksModManager;
import settingdust.preloading_tricks.fabric.FabricLoaderImplAccessor;

public class FabricModManager
implements PreloadingTricksModManager<ModContainerImpl> {
    private final List<ModContainerImpl> mods = FabricLoaderImplAccessor.mods();
    private final Map<String, ModContainerImpl> modMap = FabricLoaderImplAccessor.modMap();

    @Override
    public Collection<ModContainerImpl> all() {
        return this.mods;
    }

    @Override
    public void add(ModContainerImpl modContainer) {
        this.mods.add(modContainer);
        LoaderModMetadata metadata = modContainer.getMetadata();
        this.modMap.put(metadata.getId(), modContainer);
        for (String provides : metadata.getProvides()) {
            this.modMap.put(provides, modContainer);
        }
    }

    @Override
    public void add(ModCandidateImpl modCandidate) throws Throwable {
        FabricLoaderImplAccessor.addMod(modCandidate);
    }

    @Override
    public void addAll(Collection<ModContainerImpl> mod) {
        for (ModContainerImpl container : mod) {
            this.add(container);
        }
    }

    @Override
    public void remove(ModContainerImpl modContainer) {
        this.mods.remove(modContainer);
        LoaderModMetadata metadata = modContainer.getMetadata();
        this.modMap.remove(metadata.getId());
        for (String provide : metadata.getProvides()) {
            this.modMap.remove(provide);
        }
    }

    @Override
    public void removeIf(Predicate<ModContainerImpl> predicate) {
        List<ModContainerImpl> toRemove = this.mods.stream().filter(predicate).collect(Collectors.toList());
        this.removeAll((Collection<ModContainerImpl>)toRemove);
    }

    @Override
    public void removeAll(Collection<ModContainerImpl> modContainers) {
        if (modContainers.isEmpty()) {
            return;
        }
        this.mods.removeAll(modContainers);
        Set<String> keysToRemove = modContainers.stream().flatMap(container -> container.getMetadata().getProvides().stream()).collect(Collectors.toSet());
        keysToRemove.forEach(this.modMap::remove);
    }
}

