/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.forgelike.class_transform;

import com.google.gson.Gson;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.Type;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformConfig;

public class ClassTransformLaunchPlugin
implements ILaunchPluginService {
    private final Gson gson = new Gson();
    private final ClassTransformBootstrap classTransform;

    public ClassTransformLaunchPlugin(ClassTransformBootstrap classTransform) {
        this.classTransform = classTransform;
    }

    public String name() {
        return "Preloading Tricks Class Transform";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return EnumSet.noneOf(ILaunchPluginService.Phase.class);
    }

    public void addResources(List<SecureJar> resources) {
        for (SecureJar jar : resources) {
            String[] classTransformConfigs;
            Object classTransformConfigString = jar.moduleDataProvider().getManifest().getMainAttributes().get("ClassTransformConfig");
            if (classTransformConfigString == null) continue;
            for (String configName : classTransformConfigs = classTransformConfigString.toString().split(",")) {
                try {
                    ClassTransformConfig config = (ClassTransformConfig)this.gson.fromJson((Reader)Files.newBufferedReader(jar.getPath(configName, new String[0])), ClassTransformConfig.class);
                    this.classTransform.addConfig(config);
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

