/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.lexforge;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import settingdust.preloading_tricks.api.PreloadingTricksModManager;
import settingdust.preloading_tricks.lexforge.accessor.ModFileInfoAccessor;
import settingdust.preloading_tricks.lexforge.virtual_mod.VirtualJar;
import settingdust.preloading_tricks.lexforge.virtual_mod.VirtualModFile;

public class LexForgeModManager
implements PreloadingTricksModManager<ModFile> {
    public static List<ModFile> mods = List.of();

    public LexForgeModManager() {
        FMLLoader.class.getSimpleName();
    }

    @Override
    public Collection<ModFile> all() {
        return mods;
    }

    @Override
    public void add(ModFile mod) {
        mods.add(mod);
    }

    @Override
    public void addAll(Collection<ModFile> mod) {
        mods.addAll(mod);
    }

    @Override
    public ModFile getById(String id) {
        return mods.stream().filter(mod -> mod.getModFileInfo() != null && mod.getModInfos().stream().anyMatch(it -> it.getModId().equals(id))).findFirst().orElse(null);
    }

    @Override
    public void remove(ModFile mod) {
        mods.remove(mod);
    }

    @Override
    public void removeIf(Predicate<ModFile> predicate) {
        mods.removeIf(predicate);
    }

    @Override
    public void removeAll(Collection<ModFile> modFiles) {
        mods.removeAll(modFiles);
    }

    @Override
    public void removeById(String id) {
        this.removeByIds(Set.of(id));
    }

    @Override
    public void removeByIds(Set<String> ids) {
        Iterator<ModFile> iterator = mods.iterator();
        while (iterator.hasNext()) {
            IModFileInfo iModFileInfo;
            ModFile mod = iterator.next();
            if (mod.getModFileInfo() == null || mod.getModInfos().isEmpty() || !((iModFileInfo = mod.getModFileInfo()) instanceof ModFileInfo)) continue;
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            List<IModInfo> filtered = mod.getModInfos().stream().filter(it -> !ids.contains(it.getModId())).toList();
            if (filtered.isEmpty()) {
                iterator.remove();
                continue;
            }
            ModFileInfoAccessor.setMods(modFileInfo, filtered);
        }
    }

    @Override
    public ModFile createVirtualMod(String id, Path referencePath) {
        return new VirtualModFile(id, new VirtualJar(id, referencePath, new String[0]));
    }
}

