/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.HashMap;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleLayerAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleCopier;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleOperationHelper;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;

public class ModuleMover {
    public static void move(String moduleName, ModuleLayer sourceLayer, ModuleClassLoader sourceClassLoader, ModuleLayer targetLayer, ModuleClassLoader targetClassLoader) {
        if (sourceLayer == targetLayer || sourceClassLoader == targetClassLoader) {
            return;
        }
        ResolvedModule resolvedModule = sourceLayer.configuration().findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
        ModuleCopier.copy(moduleName, sourceLayer, targetLayer, targetClassLoader);
        ModuleLayerAccessor.getNameToModule(sourceLayer).remove(moduleName);
        ModuleOperationHelper.removeModuleFromConfiguration(sourceLayer.configuration(), resolvedModule);
        HashMap<String, ResolvedModule> sourcePackageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(sourceClassLoader));
        for (String packageName : resolvedModule.reference().descriptor().packages()) {
            sourcePackageLookup.remove(packageName);
        }
        ModuleClassLoaderAccessor.setPackageLookup(sourceClassLoader, sourcePackageLookup);
        HashMap<String, ModuleReference> sourceResolvedRoots = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(sourceClassLoader));
        sourceResolvedRoots.remove(resolvedModule.name());
        ModuleClassLoaderAccessor.setResolvedRoots(sourceClassLoader, sourceResolvedRoots);
    }

    public static void move(String moduleName, IModuleLayerManager.Layer sourceLayer, IModuleLayerManager.Layer targetLayer) {
        ModuleMover.move(moduleName, LauncherAccessor.getModuleLayer(sourceLayer), ModuleLayerHandlerAccessor.getModuleClassLoader(sourceLayer), LauncherAccessor.getModuleLayer(targetLayer), ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer));
    }

    public static void move(Class<?> classInModule, ModuleLayer targetLayer, ModuleClassLoader targetClassLoader) {
        ModuleMover.move(classInModule.getModule().getName(), classInModule.getModule().getLayer(), (ModuleClassLoader)classInModule.getClassLoader(), targetLayer, targetClassLoader);
    }

    public static void move(Class<?> classInModule, IModuleLayerManager.Layer targetLayer) {
        ModuleMover.move(classInModule, LauncherAccessor.getModuleLayer(targetLayer), ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer));
    }
}

