/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.neoforge.modlauncher;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import settingdust.preloading_tricks.api.ModManager;
import settingdust.preloading_tricks.neoforge.modlauncher.accessor.ModFileInfoAccessor;
import settingdust.preloading_tricks.neoforge.modlauncher.virtual_mod.VirtualJar;
import settingdust.preloading_tricks.neoforge.modlauncher.virtual_mod.VirtualModFile;

public class NeoForgeModManager
implements ModManager<ModFile> {
    public List<ModFile> mods = null;

    public NeoForgeModManager(List<ModFile> mods) {
        this.mods = mods;
    }

    @Override
    public Collection<ModFile> all() {
        return this.mods;
    }

    @Override
    public void add(ModFile mod) {
        this.mods.add(mod);
    }

    @Override
    public void addAll(Collection<ModFile> mod) {
        this.mods.addAll(mod);
    }

    @Override
    public ModFile getById(String id) {
        return this.mods.stream().filter(it -> it.getModFileInfo() != null && it.getModInfos().stream().anyMatch(modInfo -> modInfo.getModId().equals(id))).findFirst().orElse(null);
    }

    @Override
    public boolean remove(ModFile mod) {
        return this.mods.remove(mod);
    }

    @Override
    public boolean removeIf(Predicate<ModFile> predicate) {
        return this.mods.removeIf(predicate);
    }

    @Override
    public boolean removeAll(Collection<ModFile> all) {
        return this.mods.removeAll(all);
    }

    @Override
    public boolean removeById(String id) {
        return this.removeByIds(Set.of(id));
    }

    @Override
    public boolean removeByIds(Set<String> ids) {
        Iterator<ModFile> iterator = this.mods.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            IModFileInfo iModFileInfo;
            ModFile mod = iterator.next();
            if (mod.getModFileInfo() == null || mod.getModInfos().isEmpty() || !((iModFileInfo = mod.getModFileInfo()) instanceof ModFileInfo)) continue;
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            List<IModInfo> filtered = mod.getModInfos().stream().filter(it -> !ids.contains(it.getModId())).toList();
            if (filtered.isEmpty()) {
                iterator.remove();
                removed = true;
                continue;
            }
            if (filtered.size() == mod.getModInfos().size()) continue;
            removed = true;
            ModFileInfoAccessor.setMods(modFileInfo, filtered);
        }
        return removed;
    }

    @Override
    public ModFile createVirtualMod(String id, Path referencePath) {
        return new VirtualModFile(id, new VirtualJar(id, referencePath, new String[0]));
    }
}

