//script core ver 3.0

include(Resources.id("mtrsteamloco:scripts/config_screen.js"));
include(Resources.id("fangsu:scripts/pzx_helper.js"));
include(Resources.id("fangsu:scripts/block_connector.js"));
importPackage(java.awt);
importPackage(java.awt.geom);

var res = {};

function create(ctx, state, block) {
    if (!block.getCustomConfig("mainModel")) {
        block.putCustomConfig("mainModel", "fangsu:screendoor/kaba.json");
        block.sendUpdateC2S();
    }
    if (!block.getCustomConfig("subModelLeft")) {
        block.putCustomConfig("subModelLeft", "auto");
        block.sendUpdateC2S();
    }
    if (!block.getCustomConfig("subModelRight")) {
        block.putCustomConfig("subModelRight", "auto");
        block.sendUpdateC2S();
    }
    // state.dmhL = [];
    // state.dmhR = [];
    state.doorVal = block.doorTarget ? 1 : 0;
    state.cacheMainMod = block.getCustomConfig("mainModel");
    state.cacheSubModLeft = block.getCustomConfig("subModelLeft");
    state.cacheSubModRight = block.getCustomConfig("subModelRight");
    state.needRef = true;
    state.needRefBox = true;
    state.cacheMat = {};

    let blockConnector = getBlockConnector();
    blockConnector.initBlockState(block, { type: "SCREENDOOR_GLASS" });
    getBlockConnector().sendBlockUpdate(block, 1, 0);
}

function render(ctx, state, block) {
    let blockConnector = getBlockConnector();
    if (
        state.cacheMainMod != block.getCustomConfig("mainModel") ||
        state.cacheSubModLeft != block.getCustomConfig("subModelLeft") ||
        state.cacheSubModRight != block.getCustomConfig("subModelRight")
    ) {
        state.needRef = true;
    }

    ctx.setDebugInfo("shouldUpdate", blockConnector.shouldUpdate(block));

    if (state.needRef || blockConnector.shouldUpdate(block)) {
        try {
            for (let dm of state.dmhL) dm.close();
            for (let dm of state.dmhR) dm.close();
        } catch (e) {}

        state.cacheMainMod = block.getCustomConfig("mainModel");
        state.cacheSubModLeft = block.getCustomConfig("subModelLeft");
        state.cacheSubModRight = block.getCustomConfig("subModelRight");

        let loadedLeft = parseObj(JSON.parse(loadRes(res, "str", state.cacheMainMod)).glass.left);
        let loadedRight = parseObj(JSON.parse(loadRes(res, "str", state.cacheMainMod)).glass.right);

        let actualLoadLeft = state.cacheSubModLeft;
        let actualLoadRight = state.cacheSubModRight;

        let leftIsAuto = loadedLeft[state.cacheSubModLeft] ? loadedLeft[state.cacheSubModLeft].auto : false;
        let rightIsAuto = loadedRight[state.cacheSubModRight] ? loadedRight[state.cacheSubModRight].auto : false;
        if (leftIsAuto || rightIsAuto) {
            let basicRotate = block.getBlockYRot();
            let thisBlockPos;
            let worldPos = block.getWorldPosVector3f();
            thisBlockPos = [worldPos.x(), worldPos.y(), worldPos.z()];
            let leftBlock, rightBlock;
            if (basicRotate == 0) {
                leftBlock = [thisBlockPos[0] + 1, thisBlockPos[1], thisBlockPos[2]];
                rightBlock = [thisBlockPos[0] - 1, thisBlockPos[1], thisBlockPos[2]];
            }
            if (basicRotate == 90) {
                leftBlock = [thisBlockPos[0], thisBlockPos[1], thisBlockPos[2] + 1];
                rightBlock = [thisBlockPos[0], thisBlockPos[1], thisBlockPos[2] - 1];
            }
            if (basicRotate == 180) {
                leftBlock = [thisBlockPos[0] - 1, thisBlockPos[1], thisBlockPos[2]];
                rightBlock = [thisBlockPos[0] + 1, thisBlockPos[1], thisBlockPos[2]];
            }
            if (basicRotate == 270) {
                leftBlock = [thisBlockPos[0], thisBlockPos[1], thisBlockPos[2] - 1];
                rightBlock = [thisBlockPos[0], thisBlockPos[1], thisBlockPos[2] + 1];
            }
            let blockRelation = {
                LEFT_BLOCK: blockConnector.hasBlock(leftBlock) ? blockConnector.getBlockStateParam(leftBlock, "type") : "NULL",
                RIGHT_BLOCK: blockConnector.hasBlock(rightBlock) ? blockConnector.getBlockStateParam(rightBlock, "type") : "NULL",
                LEFT_GLASS_LEFT: blockConnector.hasBlock(leftBlock) ? blockConnector.getBlockStateParam(leftBlock, "leftGlass") : "NULL",
                LEFT_GLASS_RIGHT: blockConnector.hasBlock(leftBlock) ? blockConnector.getBlockStateParam(leftBlock, "rightGlass") : "NULL",
                RIGHT_GLASS_LEFT: blockConnector.hasBlock(rightBlock) ? blockConnector.getBlockStateParam(rightBlock, "leftGlass") : "NULL",
                RIGHT_GLASS_RIGHT: blockConnector.hasBlock(rightBlock) ? blockConnector.getBlockStateParam(rightBlock, "rightGlass") : "NULL",
                LEFT_DOOR: blockConnector.hasBlock(leftBlock) ? blockConnector.getBlockStateParam(leftBlock, "door") : "NULL",
                RIGHT_DOOR: blockConnector.hasBlock(rightBlock) ? blockConnector.getBlockStateParam(rightBlock, "door") : "NULL"
            };
            ctx.setDebugInfo("blockRelation", JSON.stringify(blockRelation));

            let autoCommands = JSON.parse(loadRes(res, "str", state.cacheMainMod)).glass.auto;
            for (let i = autoCommands.length - 1; i >= 0; i--) {
                let thisCommand = autoCommands[i];
                let isAvailable = false;
                if (thisCommand.if == "TRUE") isAvailable = true;
                if (typeof thisCommand.if == "string") {
                    isAvailable = (thisCommand.is ? blockRelation[thisCommand.if] == thisCommand.is : true) && (thisCommand.not ? blockRelation[thisCommand.if] != thisCommand.not : true);
                    // setDebugInfo(`Checking ${thisCommand.if} current is ${blockRelation[thisCommand.if]} should be ${thisCommand.is} should not be ${thisCommand.not} check state ${isAvailable}`);
                } else if (typeof thisCommand.if == "object") {
                    let hasNotInCon = false;
                    for (let key in thisCommand.if) {
                        if (thisCommand.if.hasOwnProperty(key)) {
                            hasNotInCon =
                                hasNotInCon ||
                                !((thisCommand.if[key].is ? blockRelation[key] == thisCommand.if[key].is : true) && (thisCommand.if[key].not ? blockRelation[key] != thisCommand.if[key].not : true));
                            // setDebugInfo(`Checking ${key} current is ${blockRelation[key]} should be ${thisCommand.if[key].is} should not be ${thisCommand.if[key].not} check state ${hasNotInCon}`);
                        }
                    }
                    // if (!hasNotInCon) setDebugInfo("Completed");
                    isAvailable = !hasNotInCon;
                }
                if (isAvailable) {
                    if (leftIsAuto) if (thisCommand.left) actualLoadLeft = thisCommand.left;
                    if (rightIsAuto) if (thisCommand.right) actualLoadRight = thisCommand.right;
                }
            }
        }
        ctx.setDebugInfo("actualLoadLeft", actualLoadLeft);
        ctx.setDebugInfo("actualLoadRight", actualLoadRight);

        blockConnector.setBlockStateParam(block, "leftGlass", leftIsAuto ? "AUTO" : actualLoadLeft);
        blockConnector.setBlockStateParam(block, "rightGlass", rightIsAuto ? "AUTO" : actualLoadRight);

        if (actualLoadLeft in loadedLeft) state.modelLeft = loadedLeft[actualLoadLeft];
        else {
            state.modelLeft = JSON.parse(loadRes(res, "str", state.cacheMainMod)).glass.left[0];
            block.putCustomConfig("subModelLeft", String(state.modelLeft.key));
            block.sendUpdateC2S();
        }
        if (actualLoadRight in loadedRight) state.modelRight = loadedRight[actualLoadRight];
        else {
            state.modelRight = JSON.parse(loadRes(res, "str", state.cacheMainMod)).glass.right[0];
            block.putCustomConfig("subModelRight", String(state.modelRight.key));
            block.sendUpdateC2S();
        }

        let mainModel = loadRes(res, "partedModel", JSON.parse(loadRes(res, "str", state.cacheMainMod)).model);
        // print(JSON.stringify(mainModel));
        // print(JSON.stringify(loadedLeft))
        // print(JSON.stringify(state.modelLeft))
        // for (let i = 0; i < state.model.doors.length; i++) {
        // let door = state.model.doors[i];
        // print("[DEBUG] ", door.subModel)
        let modelLeft = state.modelLeft;
        let modelRight = state.modelRight;
        let rawModelLeft = mainModel.get(modelLeft.subModel).copy();
        rawModelLeft.sourceLocation = null;
        if (JSON.parse(loadRes(res, "str", state.cacheMainMod)).flipV) rawModelLeft.applyUVMirror(false, true);
        state.dmhL = new DynamicModelHolder();
        state.dmhL.uploadLater(rawModelLeft);

        let rawModelRight = mainModel.get(modelRight.subModel).copy();
        rawModelRight.sourceLocation = null;
        if (JSON.parse(loadRes(res, "str", state.cacheMainMod)).flipV) rawModelRight.applyUVMirror(false, true);
        state.dmhR = new DynamicModelHolder();
        state.dmhR.uploadLater(rawModelRight);
        // }
        if (state.needRef) {
            blockConnector.sendBlockUpdate(block, 1, 0);
        }
        state.needRef = false;
        state.needRefBox = true;
        blockConnector.resetBlockUpdate(block);
    }

    if (block.doorTarget || block.doorValue >= 0.6) {
        state.doorVal += Timing.delta() * 0.6;
        if (state.doorVal >= 1) state.doorVal = 1;
    } else {
        state.doorVal -= Timing.delta() * 0.6;
        if (state.doorVal <= 0) state.doorVal = 0;
    }

    let shape = "";
    // for (let i = 0; i < state.model.doors.length; i++) {
    //     let door = state.model.doors[i];
    if (state.dmhL.getUploadedModel()) {
        if (state.modelLeft.shape) shape += getShape(state.modelLeft.shape, 0, 0);
        ctx.drawModel(state.dmhL, null);
        if (state.modelLeft.script) {
            try {
                for (let script of state.modelLeft.script) {
                    eval(script.scriptText + loadRes(res, "str", script.scriptFile));
                }
            } catch (e) {
                print("[ERROR] in screendoor script (left) :" + e);
            }
        }
    }
    if (state.dmhR.getUploadedModel()) {
        if (shape != "" && state.modelRight.shape) shape += "/";
        if (state.modelRight.shape) shape += getShape(state.modelRight.shape, 0, 0);
        ctx.drawModel(state.dmhR, null);
        if (state.modelRight.script) {
            try {
                for (let script of state.modelRight.script) {
                    eval(script.scriptText + loadRes(res, "str", script.scriptFile));
                }
            } catch (e) {
                print("[ERROR] in screendoor script (right) :" + e);
            }
        }
    }
    // }

    if (shape == "") {
        shape = "0,0,0,16,16,16";
    }
    if (state.cacheShape != shape) {
        state.cacheShape = shape;
        state.needRefBox = true;
        state.shape = collisionBoxStrToArr(shape);
    }

    if (
        state.cacheMat.rX != block.rotateX ||
        state.cacheMat.rY != block.rotateY ||
        state.cacheMat.rZ != block.rotateZ ||
        state.cacheMat.tX != block.translateX ||
        state.cacheMat.tY != block.translateY ||
        state.cacheMat.tZ != block.translateZ
    ) {
        // 如果有任一属性不同，则更新缓存并标记需要刷新
        state.cacheMat = {
            rX: block.rotateX,
            rY: block.rotateY,
            rZ: block.rotateZ,
            tX: block.translateX,
            tY: block.translateY,
            tZ: block.translateZ
        };
        state.needRefBox = true;
    }

    if (state.shape)
        if (state.needRefBox == true) {
            let shape = state.shape;
            let finalShape = [];
            if (shape == [[0, 0, 0, 16, 16, 16]]) {
                finalShape = [[0, 0, 0, 16, 16, 16]];
            } else
                for (let subshape of shape) {
                    // print(subshape);
                    // print(rotateCollisionBox(subshape, Math.PI * block.rotateX, Math.PI * block.rotateY, Math.PI * block.rotateZ));
                    finalShape = finalShape.concat(
                        rotateCollisionBox(subshape, block, block.rotateX, block.rotateY, block.rotateZ, block.translateX * 16, block.translateY * 16, block.translateZ * 16)
                    );
                }
            // print(finalShape);
            finalShape = collisionBoxArrToStr(finalShape);
            // print(finalShape);
            block.setShape(finalShape);
            block.setCollisionShape(finalShape);
            block.sendUpdateC2S();
            state.needRefBox = false;
        }

    ctx.setDebugInfo("mainModel", block.getCustomConfig("mainModel"));
    ctx.setDebugInfo("subModelLeft", block.getCustomConfig("subModelLeft"));
    ctx.setDebugInfo("subModelRight", block.getCustomConfig("subModelRight"));
}

function dispose(ctx, state, block) {
    getBlockConnector().sendBlockUpdate(block, 1, 0);
    getBlockConnector().disposeBlockState(block);
    try {
        state.dynamicModelHolder.close();
    } catch (e) {}
}
function use(ctx, state, block, player) {
    let configs = [];
    configs.push(buildCfgItem(ComponentUtil.getString(ComponentUtil.translatable("cfg.content.mainmodel")), "mainModel", { type: "screendoor", defaultVal: block.getCustomConfig("mainModel") }));
    configs.push(buildCfgItem(ComponentUtil.getString(ComponentUtil.translatable("cfg.content.submodel_left")), "subModel", { type: "screendoor", saveKey: "subModelLeft", path: "glass.left" }));
    configs.push(buildCfgItem(ComponentUtil.getString(ComponentUtil.translatable("cfg.content.submodel_right")), "subModel", { type: "screendoor", saveKey: "subModelRight", path: "glass.right" }));
    let sc = createConfigScreen(configs, null, { ctx, state, block });
    displayConfigScreen(sc);
}

function getShape(rawShape, doorVal, step) {
    let finalShape = "";
    for (let rs of rawShape) {
        if (finalShape != "") finalShape += "/";
        for (let i = 0; i < 6; i++) {
            if (i == 0 || i == 3) {
                finalShape += (rs[i] + parseFloat(doorVal * step * 16)).toFixed(1);
            } else {
                finalShape += rs[i].toFixed(1);
            }
            if (i != 5) finalShape += ",";
        }
    }
    return finalShape;
}
