function getBlockUniqueId(block) {
    // if (typeof block == "string") return block;
    if (Array.isArray(block)) return `block_${block[0]}_${block[1]}_${block[2]}`;
    let worldPos = block.getWorldPosVector3f();
    return `block_${worldPos.x()}_${worldPos.y()}_${worldPos.z()}`;
}

function getBlockConnector() {
    let blockConnector;
    if (GlobalRegister.containsKey("fangsu_block_connector")) blockConnector = GlobalRegister.get("fangsu_block_connector");
    else {
        blockConnector = new BlockConnector();
        GlobalRegister.put("fangsu_block_connector", blockConnector);
    }
    return blockConnector;
}

function BlockConnector() {
    this._blocks = {};
    this._blockUpdates = {};
}

BlockConnector.prototype.hasBlock = function (block) {
    // if (typeof block == "string") return this._blocks.hasOwnProperty(block);

    let blockId;
    if (Array.isArray(block)) blockId = `block_${block[0]}_${block[1]}_${block[2]}`;
    else blockId = getBlockUniqueId(block);
    return this._blocks[blockId];
};

BlockConnector.prototype.getBlockState = function (block) {
    let blockId = getBlockUniqueId(block);
    if (this.hasBlock(block)) return this._blocks[blockId];
    else return null;
};

BlockConnector.prototype.getBlockStateParam = function (block, id) {
    let blockId = getBlockUniqueId(block);
    if (this.hasBlock(block)) if (this._blocks[blockId][id] != undefined) return this._blocks[blockId][id];
    return null;
};

BlockConnector.prototype.setBlockState = function (block, state) {
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId] = state;
};

BlockConnector.prototype.disposeBlockState = function (block) {
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId] = undefined;
};

BlockConnector.prototype.initBlockState = function (block, state) {
    if (this.hasBlock(block)) return;
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId] = state;
};

BlockConnector.prototype.setBlockStateParam = function (block, id, content) {
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId][id] = content;
};

BlockConnector.prototype.sendBlockUpdate = function (block, range, height) {
    let blockId = getBlockUniqueId(block);
    let thisBlockPos = [];
    if (Array.isArray(block)) thisBlockPos = [block[0], block[1], block[2]];
    let worldPos = block.getWorldPosVector3f();
    thisBlockPos = [worldPos.x(), worldPos.y(), worldPos.z()];
    for (let x = thisBlockPos[0] - range; x <= thisBlockPos[0] + range; x++) {
        for (let z = thisBlockPos[2] - range; z <= thisBlockPos[2] + range; z++) {
            for (let y = thisBlockPos[1] - height; y <= thisBlockPos[1] + height; y++) {
                let currentBlock = getBlockUniqueId([x, y, z]);
                if (currentBlock == blockId) continue;
                this._blockUpdates[currentBlock] = true;
            }
        }
    }
    // setDebugInfo(JSON.stringify({ blockUpdates: this._blockUpdates }));
};

BlockConnector.prototype.shouldUpdate = function (block) {
    let blockId = getBlockUniqueId(block);
    return this._blockUpdates[blockId];
};

BlockConnector.prototype.resetBlockUpdate = function (block) {
    let blockId = getBlockUniqueId(block);
    // setDebugInfo(JSON.stringify({ blockUpdates: this._blockUpdates }));
    // setDebugInfo(`resetting ${blockId}`);

    this._blockUpdates[blockId] = false;
    // setDebugInfo(JSON.stringify({ blockUpdates: this._blockUpdates }));
    return;
};
