function getBlockUniqueId(block) {
    // if (typeof block == "string") return block;
    if (Array.isArray(block)) return `block_${block[0]}_${block[1]}_${block[2]}`;
    let worldPos = block.getWorldPosVector3f();
    return `block_${worldPos.x()}_${worldPos.y()}_${worldPos.z()}`;
}

function getBlockConnector() {
    let blockConnector;
    if (GlobalRegister.containsKey("fangsu_block_connector")) blockConnector = GlobalRegister.get("fangsu_block_connector");
    else {
        blockConnector = new BlockConnector();
        GlobalRegister.put("fangsu_block_connector", blockConnector);
    }
    return blockConnector;
}

function BlockConnector() {
    this._blocks = {};
}

BlockConnector.prototype.hasBlock = function (block) {
    // if (typeof block == "string") return this._blocks.hasOwnProperty(block);

    let blockId;
    if (Array.isArray(block)) blockId = `block_${block[0]}_${block[1]}_${block[2]}`;
    else blockId = getBlockUniqueId(block);
    return this._blocks.hasOwnProperty(blockId);
};

BlockConnector.prototype.getBlockState = function (block) {
    let blockId = getBlockUniqueId(block);
    if (this.hasBlock(block)) return this._blocks[blockId];
    else return null;
};

BlockConnector.prototype.getBlockStateParam = function (block, id) {
    let blockId = getBlockUniqueId(block);
    if (this.hasBlock(block)) if (this._blocks[blockId].hasOwnProperty(id)) return this._blocks[blockId][id];
    return null;
};

BlockConnector.prototype.setBlockState = function (block, state) {
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId] = state;
};

BlockConnector.prototype.initBlockState = function (block, state) {
    if (this.hasBlock(block)) return;
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId] = state;
};

BlockConnector.prototype.setBlockStateParam = function (block, id, content) {
    let blockId = getBlockUniqueId(block);
    this._blocks[blockId][id] = content;
};
