function checkConfig(block, configName, defaultVal) {
    let custom = block.getCustomConfig(configName);
    if (!custom) {
        // print("[DEBUG] @ costom_item_helper.js : ", configName, " is not available as ", custom);
        block.putCustomConfig(configName, String(defaultVal));
        block.sendUpdateC2S();
        return defaultVal;
    }
    // print("[DEBUG] @ costom_item_helper.js : ", configName, " is available : ", custom);
    if (custom == "false") return false;
    if (custom == "0") return 0;
    return custom;
}

function checkAndCacheConfig(block, state, configName, defaultVal) {
    let custom = block.getCustomConfig(configName);
    let cackeKey = `cache${configName.charAt(0).toUpperCase() + configName.slice(1)}`;
    if (!custom) {
        // print("[DEBUG] @ costom_item_helper.js : ", configName, " is not available as ", custom);
        block.putCustomConfig(configName, String(defaultVal));
        block.sendUpdateC2S();
        state[cackeKey] = defaultVal;
        return defaultVal;
    }
    // print("[DEBUG] @ costom_item_helper.js : ", configName, " is available : ", custom);
    let finalVal = String(custom);
    if (custom == "true") finalVal = true;
    if (custom == "false") finalVal = false;
    if (!isNaN(parseFloat(custom)) && isFinite(custom)) finalVal = parseFloat(custom);
    state[cackeKey] = finalVal;
    return finalVal;
}

function checkCache(block, state, configName) {
    let custom = String(block.getCustomConfig(configName));
    if (custom == "true") custom = true;
    if (custom == "false") custom = false;
    if (!isNaN(parseFloat(custom)) && isFinite(custom)) finalVal = parseFloat(custom);
    let cackeKey = `cache${configName.charAt(0).toUpperCase() + configName.slice(1)}`;
    let cache = state[cackeKey];
    let current = state[configName];
    let flag = false;
    if (cache != custom) {
        state[configName] = custom;
        state[cackeKey] = current;
        setDebugInfo(`the cache of ${configName} is ${current} (${typeof current}) which is different in custom ${custom} (${typeof custom})`);

        flag = true;
    }
    if (current != cache) {
        setDebugInfo(`the current of ${configName} is ${current} (${typeof current}) which is different in cache ${cache} (${typeof cache})`);
        flag = true;
    }
    if (flag) {
        block.putCustomConfig(configName, String(current));
        block.sendUpdateC2S();
        state[cackeKey] = current;
    }
    return flag;
}
