/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.compat.jei;

import com.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.klikli_dev.occultism.integration.jei.impl.JeiRecipeTypes;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.compat.jei.category.FanEnspiritCategory;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlocks;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringFluids;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    protected static IJeiRuntime runtime;
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();

    public void loadCategories() {
        this.allCategories.clear();
        this.builder(SpiritFireRecipe.class).addTypedRecipes((Supplier)OccultismRecipes.SPIRIT_FIRE_TYPE).catalystStack(JeiPlugin.getOcEngFan("fan_enspirit")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)OccultismBlocks.SPIRIT_CAMPFIRE.get()).emptyBackground(178, 72).build(OccultEngineering.asResource("fan_enspirit"), FanEnspiritCategory::new);
    }

    private static Supplier<ItemStack> getOcEngFan(String name) {
        ItemStack stack = AllBlocks.ENCASED_FAN.asStack();
        stack.set(DataComponents.CUSTOM_NAME, (Object)OccultEngineering.lang().translate(name + ".fan", new Object[0]).component().withStyle(s -> s.withItalic(Boolean.valueOf(false))));
        return () -> stack;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<T> cls) {
        return new CategoryBuilder<T>(cls);
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        ArrayList<FluidStack> fluidIngredients = new ArrayList<FluidStack>();
        fluidIngredients.add(new FluidStack((Fluid)OccultEngineeringFluids.SPIRIT_SOLUTION.get(), 1000));
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidIngredients);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return OccultEngineering.asResource("jei");
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
        OccultEngineering.LOGGER.info("{} registered {} recipe catalysts", (Object)this.getPluginUid(), (Object)this.allCategories.size());
        registration.addRecipeCatalyst(new ItemStack(OccultEngineeringBlocks.MECHANICAL_CHAMBER), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack(OccultEngineeringBlocks.MECHANICAL_PULVERIZER), new RecipeType[]{JeiRecipeTypes.CRUSHING});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        OccultEngineering.LOGGER.info("{} registered {} recipes", (Object)this.getPluginUid(), (Object)this.allCategories.size());
    }

    private class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            JeiPlugin.this.allCategories.add(category);
            return category;
        }
    }
}

