/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.entity.puca;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrain;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrainFactory;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrainSupplantable;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.brain.PucaBrain;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBrains;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringEntities;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PucaEntity
extends PathfinderMob
implements GeoEntity,
SmartBrainOwner<PucaEntity>,
DynamicBrainSupplantable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    protected PucaBrain dynamicBrain;
    @Nullable
    public BlockPos returnHomePosition;
    @Nullable
    public BlockPos nextTargetPos;
    @Nullable
    public BlockState nextBlockState;
    @NotNull
    public ItemStack heldItem = ItemStack.EMPTY;
    protected boolean hasJumped = false;
    protected static final EntityDataAccessor<String> DYNAMIC_BRAIN_ID = SynchedEntityData.defineId(PucaEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public PucaEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public PucaEntity(Level level, ItemStack heldItem, BlockState stateToPlace, BlockPos pos) {
        this(OccultEngineeringEntities.PUCA.get(), level);
        this.heldItem = heldItem;
    }

    public static PucaEntity genericPuca(EntityType<?> entityType, Level level) {
        PucaEntity e = new PucaEntity(entityType, level);
        e.supplantBrain(((DynamicBrainFactory)OccultEngineeringBrains.PUCA_WANDER.get()).create(e));
        return e;
    }

    public void jumpNow() {
        this.jumpControl.jump();
        this.hasJumped = true;
        this.triggerAnim("main", "jump");
    }

    public boolean getHasJumped() {
        return this.hasJumped;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "main", 1, this::animPredicate).triggerableAnim("jump", RawAnimation.begin().thenPlayAndHold("jump")));
    }

    public PlayState animPredicate(AnimationState<PucaEntity> animState) {
        if (!((PucaEntity)animState.getAnimatable()).onGround()) {
            return PlayState.CONTINUE;
        }
        return animState.setAndContinue(RawAnimation.begin().thenPlay("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ARMOR, 2.0);
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this, true);
    }

    public void handleAdditionalBrainSetup(SmartBrain<? extends PucaEntity> brain) {
        if (this.dynamicBrain != null) {
            this.dynamicBrain.onBrainSetup(brain);
        }
    }

    public List<? extends ExtendedSensor<? extends PucaEntity>> getSensors() {
        return this.dynamicBrain != null ? this.dynamicBrain.getSensors() : ImmutableList.of();
    }

    public BrainActivityGroup<PucaEntity> getCoreTasks() {
        return this.dynamicBrain != null ? this.dynamicBrain.getCoreTasks() : BrainActivityGroup.empty();
    }

    public BrainActivityGroup<PucaEntity> getIdleTasks() {
        return this.dynamicBrain != null ? this.dynamicBrain.getIdleTasks() : BrainActivityGroup.empty();
    }

    @Override
    public void supplantBrain(DynamicBrain<? extends LivingEntity> newBrain) {
        OccultEngineering.LOGGER.info("Supplanting {}", (Object)newBrain.brainID.toString());
        if (this.dynamicBrain != null) {
            this.dynamicBrain.onCleanup();
        }
        this.dynamicBrain = (PucaBrain)newBrain;
        this.remakeBrain();
    }

    public boolean dynamicBrainIs(ResourceLocation brainLoc) {
        if (this.dynamicBrain == null) {
            return false;
        }
        return this.dynamicBrain.brainID.equals((Object)brainLoc);
    }

    public void remakeBrain() {
        NbtOps nbtops = NbtOps.INSTANCE;
        this.brain = this.makeBrain(new Dynamic((DynamicOps)nbtops, (Object)((Tag)nbtops.createMap((Map)ImmutableMap.of((Object)nbtops.createString("memories"), (Object)((Tag)nbtops.emptyMap()))))));
    }

    protected void customServerAiStep() {
        if (this.dynamicBrain != null) {
            this.dynamicBrain.tick();
        }
        this.tickBrain((LivingEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.onGround()) {
            this.hasJumped = false;
        }
    }

    public void setReturnHomePosition(BlockPos position) {
        this.returnHomePosition = position;
    }

    public void setNextPlacePosition(BlockPos position, BlockState state, ItemStack heldItem) {
        this.nextTargetPos = position;
        this.nextBlockState = state;
        this.heldItem = heldItem;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    public ItemStack getItemBySlot(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return this.heldItem;
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.heldItem = itemStack;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.dynamicBrain != null) {
            compound.putString("DynamicBrainID", this.dynamicBrain.brainID.toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }
}

