/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.ponder.OccultEngineeringPonderPlugin;
import io.github.irishgreencitrus.occultengineering.datagen.PentacleProvider;
import io.github.irishgreencitrus.occultengineering.datagen.book.UnifiedBookProvider;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngRecipeProvider;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngStandardRecipeGen;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class DataProviders {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new OcEngStandardRecipeGen(output, registries));
        DataProviders.createBook(event, generator);
        if (event.includeServer()) {
            OcEngRecipeProvider.registerAllProcessing(generator, output, registries);
        }
    }

    private static void createBook(GatherDataEvent event, DataGenerator generator) {
        generator.addProvider(event.includeServer(), (DataProvider)new PentacleProvider(generator));
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/occultengineering/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = new String(((JsonElement)entry.getValue()).getAsString().getBytes(), StandardCharsets.UTF_8);
            consumer.accept(key, value);
        }
    }

    private static void providerPonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new OccultEngineeringPonderPlugin());
        PonderIndex.getLangAccess().provideLang("occultengineering", consumer);
    }

    public static void registerRegistrateProviders() {
        OccultEngineering.LOGGER.info("Registering additional language providers");
        OccultEngineering.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            OccultEngineering.LOGGER.info("Running additional language providers for Occult Engineering");
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            UnifiedBookProvider.bookData.forEach(langConsumer);
            DataProviders.provideDefaultLang("interface", langConsumer);
            DataProviders.provideDefaultLang("tooltips", langConsumer);
            DataProviders.providerPonderLang(langConsumer);
        });
        OccultEngineering.REGISTRATE.addDataGenerator(ProviderType.GENERIC_SERVER, p -> p.add(UnifiedBookProvider::new));
    }
}

