/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer;

import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer.PulverizerBlock;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PulverizerBlockEntity
extends KineticBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(1);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new PulverizerInventoryHandler());
    public int timer;
    private CrushingRecipe lastRecipe;

    public PulverizerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        float pitch = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.CRUSHING, (BlockPos)this.f_58858_, (float)pitch);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.outputInv.getStackInSlot(0).m_41613_() == this.outputInv.getStackInSlot(0).m_41741_()) {
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        if (this.timer <= 0) {
            if (this.inputInv.getStackInSlot(0).m_41619_()) {
                return;
            }
            Optional<CrushingRecipe> recipe = this.findCurrentRecipe(this.inputInv.getStackInSlot(0));
            this.timer = recipe.map(CrushingRecipe::getCrushingTime).orElse(100);
            this.notifyUpdate();
        } else {
            this.timer -= this.getProcessingSpeed();
            if (this.f_58857_.f_46443_) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
                this.notifyUpdate();
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
    }

    private void process() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack inputStack = this.inputInv.getStackInSlot(0);
        Optional<CrushingRecipe> recipe = this.findCurrentRecipe(inputStack);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStackFakeInventory input = new ItemStackFakeInventory(inputStack);
        ItemStack result = recipe.get().assemble(input, this.f_58857_.m_9598_());
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.outputInv, (ItemStack)result, (boolean)true);
        if (!remainder.m_41619_()) {
            return;
        }
        inputStack.m_41774_(1);
        this.inputInv.setStackInSlot(0, inputStack);
        ItemHandlerHelper.insertItem((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
    }

    public boolean canProcess(ItemStack stack) {
        if (this.f_58857_ == null) {
            return false;
        }
        Optional<CrushingRecipe> recipe = this.findCurrentRecipe(stack);
        if (recipe.isEmpty()) {
            return false;
        }
        boolean emptySlot = this.outputInv.getStackInSlot(0).m_41619_();
        if (emptySlot) {
            return true;
        }
        ItemStackFakeInventory input = new ItemStackFakeInventory(stack);
        boolean matchingItem = this.outputInv.getStackInSlot(0).m_150930_(recipe.get().assemble(input, this.f_58857_.m_9598_()).m_41720_());
        if (!matchingItem) {
            return false;
        }
        ItemStack output = recipe.get().assemble(input, this.f_58857_.m_9598_());
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.outputInv, (ItemStack)output, (boolean)true);
        return remainder.m_41619_();
    }

    private Optional<CrushingRecipe> findCurrentRecipe(ItemStack stack) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        ItemStackFakeInventory input = new ItemStackFakeInventory(stack);
        if (this.lastRecipe != null && this.lastRecipe.matches(input, this.f_58857_)) {
            return Optional.ofNullable(this.lastRecipe);
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)OccultismRecipes.CRUSHING_TYPE.get(), (Container)input, this.f_58857_);
        recipe.ifPresent(r -> {
            this.lastRecipe = r;
        });
        return recipe;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("timer", this.timer);
        compound.m_128365_("input_inventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("output_inventory", (Tag)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.timer = compound.m_128451_("timer");
        this.inputInv.deserializeNBT(compound.m_128469_("input_inventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("output_inventory"));
        super.read(compound, clientPacket);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private void spawnParticles() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188503_(3) != 0) {
            return;
        }
        ItemStack item = this.inputInv.getStackInSlot(0);
        if (item.m_41619_()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, item);
        float yRot = -((Direction)this.m_58900_().m_61143_(PulverizerBlock.HORIZONTAL_FACING)).m_122435_();
        Vec3 center = this.f_58858_.m_252807_();
        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 0.0, 0.5), (double)yRot, (Direction.Axis)Direction.Axis.Y);
        offset = VecHelper.offsetRandomly((Vec3)offset, (RandomSource)this.f_58857_.f_46441_, (float)0.015625f);
        center = center.m_82549_(offset);
        Vec3 target = VecHelper.rotate((Vec3)new Vec3(0.0, -0.5, (double)0.2f), (double)yRot, (Direction.Axis)Direction.Axis.Y);
        this.f_58857_.m_7106_((ParticleOptions)data, center.f_82479_, center.f_82480_, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    private class PulverizerInventoryHandler
    extends CombinedInvWrapper {
        public PulverizerInventoryHandler() {
            super(new IItemHandlerModifiable[]{PulverizerBlockEntity.this.inputInv, PulverizerBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (PulverizerBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return PulverizerBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (PulverizerBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (PulverizerBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

