/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.pentacleschematics;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.TagMatcher;
import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleMaterialChecklist;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleSchematic;
import io.github.irishgreencitrus.occultengineering.mixin.accessor.TagMatcherAccessor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.NotImplementedException;

public class PentaclePrinter {
    private PentacleSchematic schematic;
    private BlockPos anchor;
    private List<BlockPos> positionToPrint;
    private int currentPosIndex = 0;
    private Map<BlockPos, Either<BlockState, TagKey<Block>>> toPlace = new HashMap<BlockPos, Either<BlockState, TagKey<Block>>>();
    private boolean initialised = false;
    private Level level;
    Direction[] validHorizontalDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public void initialise(PentacleSchematic schematic) {
        this.level = schematic.getLevel();
        this.schematic = schematic;
        this.anchor = schematic.position;
        Collection simResults = (Collection)schematic.getCurrentSimulationResult().getSecond();
        this.positionToPrint = simResults.stream().map(Multiblock.SimulateResult::getWorldPosition).sorted((o1, o2) -> Comparator.comparingInt(Vec3i::m_123342_).thenComparingInt(Vec3i::m_123343_).thenComparingInt(Vec3i::m_123341_).compare((Vec3i)o1, (Vec3i)o2)).toList();
        for (Multiblock.SimulateResult result : simResults) {
            StateMatcher stateMatcher = result.getStateMatcher();
            if (stateMatcher instanceof TagMatcher) {
                TagMatcher tm = (TagMatcher)stateMatcher;
                TagMatcherAccessor tagAccessor = (TagMatcherAccessor)tm;
                this.toPlace.put(result.getWorldPosition(), (Either<BlockState, TagKey<Block>>)Either.right(tagAccessor.getTag().get()));
                continue;
            }
            this.toPlace.put(result.getWorldPosition(), (Either<BlockState, TagKey<Block>>)Either.left((Object)result.getStateMatcher().getDisplayedState(0L)));
        }
        this.initialised = true;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public void deinit() {
        this.initialised = false;
        this.level = null;
        this.schematic = null;
        this.anchor = null;
        this.toPlace.clear();
    }

    public boolean placeNextBlock() {
        if (!this.hasNextPlace()) {
            this.deinit();
            return false;
        }
        BlockPos pos = this.positionToPrint.get(this.currentPosIndex++);
        assert (this.toPlace.containsKey(pos));
        Either<BlockState, TagKey<Block>> nextToPlace = this.toPlace.get(pos);
        if (nextToPlace.left().isPresent()) {
            this.setBlock(pos, (BlockState)nextToPlace.left().get());
        } else {
            TagKey tag = (TagKey)nextToPlace.right().get();
            ImmutableList all = ImmutableList.copyOf((Iterable)ForgeRegistries.BLOCKS.tags().getTag(tag));
            if (all.isEmpty()) {
                return false;
            }
            BlockState state = ((Block)all.get(0)).m_49966_();
            this.setBlock(pos, state);
        }
        return true;
    }

    public boolean hasNextPlace() {
        if (!this.isInitialised()) {
            return false;
        }
        return this.currentPosIndex < this.positionToPrint.size() && this.currentPosIndex >= 0;
    }

    public Either<BlockState, TagKey<Block>> getNextStateToPlace() {
        return this.toPlace.get(this.positionToPrint.get(this.currentPosIndex));
    }

    public Pair<BlockPos, Either<BlockState, TagKey<Block>>> getNextToPlace() {
        BlockPos pos = this.positionToPrint.get(this.currentPosIndex);
        return Pair.of((Object)pos, this.toPlace.get(pos));
    }

    public Pair<BlockPos, Either<BlockState, TagKey<Block>>> popNextToPlace() {
        Pair<BlockPos, Either<BlockState, TagKey<Block>>> x = this.getNextToPlace();
        ++this.currentPosIndex;
        return x;
    }

    private void setBlock(BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof ChalkGlyphBlock) {
            state = (BlockState)((BlockState)state.m_61124_((Property)ChalkGlyphBlock.SIGN, (Comparable)Integer.valueOf(this.level.m_213780_().m_188503_(13)))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)this.validHorizontalDirections[this.level.m_213780_().m_188503_(this.validHorizontalDirections.length)]);
        }
        if (state.m_60734_() instanceof CandleBlock) {
            state = (BlockState)state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
        }
        this.level.m_46961_(pos, true);
        this.level.m_7731_(pos, state, 3);
        try {
            state.m_60734_().m_6402_(this.level, pos, state, null, new ItemStack((ItemLike)state.m_60734_()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void placeAll() {
        while (this.hasNextPlace()) {
            this.placeNextBlock();
        }
    }

    public ItemRequirement getStillToPlaceRequrement() {
        if (!this.initialised) {
            return ItemRequirement.INVALID;
        }
        ItemRequirement newRequirement = ItemRequirement.NONE;
        ItemRequirement currentRequirement = this.schematic.getItemRequirement();
        for (ItemRequirement.StackRequirement requirement : currentRequirement.getRequiredItems()) {
            currentRequirement = currentRequirement.union(new ItemRequirement(requirement));
        }
        return newRequirement;
    }

    public ItemRequirement getCurrentRequirement() {
        throw new NotImplementedException();
    }

    public int markBlockRequirements(PentacleMaterialChecklist checklist, Level world, SchematicPrinter.PlacementPredicate predicate) {
        throw new NotImplementedException();
    }
}

