/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.phlogiport;

import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.PhlogiportSignalParticleData;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhlogiportSignalParticle
extends TextureSheetParticle {
    private final PositionSource target;
    private final Vec3 startingPosition;
    public static final Vec3 offset = new Vec3(0.0, 0.40625, 0.0);

    protected PhlogiportSignalParticle(ClientLevel level, double x, double y, double z, PositionSource target, int lifetime) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107663_ = 0.5f;
        this.target = target;
        this.f_107225_ = lifetime;
        this.startingPosition = new Vec3(x, y, z);
        this.f_107219_ = false;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        Optional targetPos = this.target.m_142502_((Level)this.f_107208_);
        if (targetPos.isEmpty()) {
            this.m_107274_();
            return;
        }
        float percentage = (float)this.f_107224_ / (float)this.f_107225_;
        Vec3 newPos = this.startingPosition.m_165921_(((Vec3)targetPos.get()).m_82549_(offset), (double)percentage);
        this.f_107212_ = newPos.m_7096_();
        this.f_107213_ = newPos.m_7098_();
        this.f_107214_ = newPos.m_7094_();
        this.m_107264_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        this.renderSignal(vertexConsumer, camera, partialTicks, q -> q.rotateZ(this.f_107231_ + (float)Math.PI));
        this.renderSignal(vertexConsumer, camera, partialTicks, q -> q.rotateY((float)(-Math.PI)).rotateZ(this.f_107231_));
    }

    private void renderSignal(VertexConsumer buffer, Camera camera, float partialTicks, Consumer<Quaternionf> quatConsumer) {
        Vec3 currentPos = new Vec3(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_), Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_), Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_));
        Quaternionf rotation = new Quaternionf();
        Optional targetPosOpt = this.target.m_142502_((Level)this.f_107208_);
        if (targetPosOpt.isPresent()) {
            Vector3f travelAxis = ((Vec3)targetPosOpt.get()).m_82549_(offset).m_82546_(currentPos).m_82541_().m_252839_();
            Vector3f localX = travelAxis.normalize();
            localX.normalize();
            Vector3f localY = new Vector3f(0.0f, 1.0f, 0.0f);
            localY = camera.m_253028_();
            localY.normalize();
            Vector3f localZ = new Vector3f();
            localX.cross((Vector3fc)localY, localZ);
            localZ.normalize();
            localZ.cross((Vector3fc)localX, localY);
            localY.normalize();
            Matrix3f rotMatrix = new Matrix3f((Vector3fc)localX, (Vector3fc)localY, (Vector3fc)localZ);
            rotation.setFromNormalized((Matrix3fc)rotMatrix);
        } else {
            rotation.set((Quaternionfc)camera.m_253121_());
        }
        Vec3 cameraPos = camera.m_90583_();
        double particleX = currentPos.f_82479_ - cameraPos.f_82479_;
        double particleY = currentPos.f_82480_ - cameraPos.f_82480_;
        double particleZ = currentPos.f_82481_ - cameraPos.f_82481_;
        Vector3f[] quad = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        quatConsumer.accept(rotation);
        float quadSize = this.m_5902_(partialTicks);
        for (Vector3f corner : quad) {
            corner.rotate((Quaternionfc)rotation);
            corner.mul(quadSize);
            corner.add((float)particleX, (float)particleY, (float)particleZ);
        }
        float u0 = this.m_5970_();
        float v0 = this.m_5951_();
        float u1 = this.m_5952_();
        float v1 = this.m_5950_();
        float[] ucoords = new float[]{u1, u1, u0, u0};
        float[] vcoords = new float[]{v1, v0, v0, v1};
        int lightLevel = this.m_6355_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f corner = quad[i];
            buffer.m_5483_((double)corner.x, (double)corner.y, (double)corner.z).m_7421_(ucoords[i], vcoords[i]).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightLevel).m_5752_();
        }
    }

    protected int m_6355_(float partialTick) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<PhlogiportSignalParticleData> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(PhlogiportSignalParticleData type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PhlogiportSignalParticle particle = new PhlogiportSignalParticle(level, x, y, z, type.getDestination(), type.getLifetime());
            particle.m_108335_(this.sprite);
            particle.m_107271_(1.0f);
            return particle;
        }
    }
}

