/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.pucalith;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PucalithBlock
extends HorizontalDirectionalBlock
implements IBE<PucalithBlockEntity> {
    public static final MapCodec<PucalithBlock> CODEC = PucalithBlock.simpleCodec(PucalithBlock::new);

    public PucalithBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> player.openMenu((MenuProvider)be, arg_0 -> ((PucalithBlockEntity)((Object)be)).sendToMenu(arg_0)));
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> ItemHelper.dropContents((Level)level, (BlockPos)pos, (IItemHandler)be.inventory));
        level.removeBlockEntity(pos);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public Class<PucalithBlockEntity> getBlockEntityClass() {
        return PucalithBlockEntity.class;
    }

    public BlockEntityType<? extends PucalithBlockEntity> getBlockEntityType() {
        return (BlockEntityType)OccultEngineeringBlockEntities.PUCALITH.get();
    }
}

