/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.MechanicalChamberBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringPartialModels;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MechanicalChamberRenderer
extends KineticBlockEntityRenderer<MechanicalChamberBlockEntity> {
    public MechanicalChamberRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void renderSafe(MechanicalChamberBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.renderSafe((KineticBlockEntity)blockEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (blockEntity.itemStackHandler == null) {
            OccultEngineering.LOGGER.warn("itemStackHandler is null");
            return;
        }
        ItemStack stack = blockEntity.itemStackHandler.getStackInSlot(0);
        long time = blockEntity.m_58904_().m_46467_();
        Direction facing = Direction.UP;
        poseStack.m_85836_();
        poseStack.m_85836_();
        double offset = Math.sin(((float)(time - blockEntity.lastChangeTime) + partialTicks) / 16.0f) * 0.5 + 0.5;
        double fixedOffset = 0.2;
        double yOffset = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -(offset /= 7.0) - fixedOffset;
        poseStack.m_85837_(0.5, 0.15 + yOffset, 0.5);
        long systemTime = blockEntity.m_58904_().m_46467_();
        float angle = systemTime / 16L % 360L;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        float scale = 0.5f;
        poseStack.m_85841_(scale, scale, scale);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, blockEntity.m_58904_(), null, 0);
        itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, model);
        poseStack.m_85849_();
        poseStack.m_252781_(facing.m_253075_());
        poseStack.m_85849_();
    }

    protected SuperByteBuffer getRotatedModel(MechanicalChamberBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)OccultEngineeringPartialModels.SHAFT_SPLIT, (BlockState)state, (Direction)Direction.UP);
    }
}

