/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.item;

import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.mojang.datafixers.util.Either;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentaclePrinter;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleSchematic;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PentacleSchematicItem
extends Item {
    private static PentaclePrinter printer;

    public PentacleSchematicItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack create(ResourceLocation pentacleLocation) {
        ItemStack blueprint = OccultEngineeringItems.PENTACLE_SCHEMATIC.asStack();
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Deployed", false);
        tag.m_128359_("Pentacle", pentacleLocation.toString());
        tag.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)BlockPos.f_121853_));
        tag.m_128365_("Bounds", (Tag)NBTHelper.writeVec3i((Vec3i)MultiblockDataManager.get().getMultiblock(pentacleLocation).getSize()));
        blueprint.m_41751_(tag);
        return blueprint;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        String pentacleTag;
        ResourceLocation pentacleResource;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Pentacle") && (pentacleResource = ResourceLocation.m_135820_((String)(pentacleTag = stack.m_41783_().m_128461_("Pentacle")))) != null) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.occultengineering.pentacle_schematic.tooltip_prefix").m_7220_((Component)Component.m_237115_((String)("multiblock." + pentacleResource.m_135827_() + "." + pentacleResource.m_135815_())).m_130940_(ChatFormatting.RED)));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!tag.m_128441_("Pentacle")) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_6144_() && player.m_20096_()) {
            if (player.m_7500_()) {
                if (tag.m_128441_("Deployed") && tag.m_128441_("Position")) {
                    boolean deployed = tag.m_128471_("Deployed");
                    BlockPos tagPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Position"));
                    if (deployed && tagPos.equals((Object)player.m_20183_())) {
                        Either<PentacleSchematic, PentacleSchematic.ParseResult> schem = PentacleSchematic.fromStack(level, stack);
                        if (schem.left().isEmpty()) {
                            return InteractionResultHolder.m_19100_((Object)stack);
                        }
                        ((PentacleSchematic)schem.orThrow()).instantPlace();
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                }
                player.m_5661_((Component)Component.m_237110_((String)"gui.occultengineering.pentacle_schematic.place_hint_creative", (Object[])new Object[]{player.m_20183_().m_123344_()}).m_130940_(ChatFormatting.GREEN), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"gui.occultengineering.pentacle_schematic.place_hint", (Object[])new Object[]{player.m_20183_().m_123344_()}).m_130940_(ChatFormatting.GREEN), true);
            }
            tag.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)player.m_20183_()));
            tag.m_128379_("Deployed", true);
            stack.m_41751_(tag);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }
}

