/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.phlogiport;

import com.simibubi.create.content.logistics.box.PackageItem;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.config.OccultEngineeringConfig;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.IPhlogiportNetworkable;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.levelWrappers.WorldHelper;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PhlogiportNetworkHandler {
    private static final Map<LevelAccessor, Map<String, Set<IPhlogiportNetworkable>>> phlogiportNetwork = new IdentityHashMap<LevelAccessor, Map<String, Set<IPhlogiportNetworkable>>>();
    private static final Random randomInstance = new Random();

    public void onLoadWorld(LevelAccessor world) {
        phlogiportNetwork.put(world, new HashMap());
        OccultEngineering.LOGGER.debug("Added Phlogiport network for {}", (Object)WorldHelper.getDimensionID((LevelAccessor)world));
    }

    public void onUnloadWorld(LevelAccessor world) {
        phlogiportNetwork.remove(world);
        OccultEngineering.LOGGER.debug("Removed Phlogiport network for {}", (Object)WorldHelper.getDimensionID((LevelAccessor)world));
    }

    public void addToNetwork(LevelAccessor world, IPhlogiportNetworkable phlogiport) {
        if (phlogiport.getAddress() == null) {
            return;
        }
        this.getNetworkOf(world, phlogiport).add(phlogiport);
    }

    public void removeFromNetwork(LevelAccessor world, IPhlogiportNetworkable phlogiport) {
        if (phlogiport.getAddress() == null) {
            return;
        }
        Set<IPhlogiportNetworkable> network = this.getNetworkOf(world, phlogiport);
        network.remove(phlogiport);
        if (network.isEmpty()) {
            this.getNetworkFor(world).remove(phlogiport.getAddress());
        }
    }

    @Nullable
    public IPhlogiportNetworkable findMatchingPhlogiport(LevelAccessor world, IPhlogiportNetworkable sender, String destinationAddress) {
        if (Objects.equals(sender.getAddress(), destinationAddress)) {
            return null;
        }
        Map<String, Set<IPhlogiportNetworkable>> worldNetwork = this.getNetworkFor(world);
        Set<IPhlogiportNetworkable> possiblePhlogiports = worldNetwork.get(destinationAddress);
        if (possiblePhlogiports == null || possiblePhlogiports.isEmpty()) {
            possiblePhlogiports = worldNetwork.values().stream().flatMap(Collection::stream).filter(p -> PackageItem.matchAddress((String)destinationAddress, (String)p.getAddress())).collect(Collectors.toSet());
        }
        if (possiblePhlogiports.isEmpty()) {
            return null;
        }
        List<IPhlogiportNetworkable> validReceivers = possiblePhlogiports.stream().filter(IPhlogiportNetworkable::isReceiving).filter(r -> !r.equals(sender)).filter(r -> PhlogiportNetworkHandler.isInRange(r, sender)).filter(r -> world.m_7726_().m_5563_(SectionPos.m_123171_((int)r.getLocation().m_123341_()), SectionPos.m_123171_((int)r.getLocation().m_123343_()))).toList();
        if (validReceivers.isEmpty()) {
            return null;
        }
        return validReceivers.get(randomInstance.nextInt(validReceivers.size()));
    }

    public static boolean isInRange(IPhlogiportNetworkable sender, IPhlogiportNetworkable receiver) {
        Integer distance = (Integer)OccultEngineeringConfig.server().phlogiportRangeBlocks.get();
        return sender.getLocation().m_123331_((Vec3i)receiver.getLocation()) <= (double)(distance * distance);
    }

    public Set<IPhlogiportNetworkable> getNetworkOf(LevelAccessor world, IPhlogiportNetworkable phlogiport) {
        String address;
        Map<String, Set<IPhlogiportNetworkable>> worldNetwork = this.getNetworkFor(world);
        if (!worldNetwork.containsKey(address = phlogiport.getAddress())) {
            worldNetwork.put(address, new LinkedHashSet());
        }
        return worldNetwork.get(address);
    }

    public Map<String, Set<IPhlogiportNetworkable>> getNetworkFor(LevelAccessor world) {
        if (!phlogiportNetwork.containsKey(world)) {
            OccultEngineering.LOGGER.warn("Phlogiport network not initialised in {}", (Object)WorldHelper.getDimensionID((LevelAccessor)world));
            return new HashMap<String, Set<IPhlogiportNetworkable>>();
        }
        return phlogiportNetwork.get(world);
    }
}

