/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.ponder.OccultEngineeringPonderPlugin;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngCompactingRecipeGen;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngFillingRecipeGen;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngItemApplicationRecipeGen;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngMixingRecipeGen;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngStandardRecipeGen;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataProviders {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new OcEngCompactingRecipeGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new OcEngMixingRecipeGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new OcEngFillingRecipeGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new OcEngItemApplicationRecipeGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new OcEngStandardRecipeGen(output));
        OccultEngineering.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            DataProviders.provideDefaultLang("interface", langConsumer);
            DataProviders.provideDefaultLang("tooltips", langConsumer);
            DataProviders.providerPonderLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/occultengineering/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = new String(((JsonElement)entry.getValue()).getAsString().getBytes(), StandardCharsets.UTF_8);
            consumer.accept(key, value);
        }
    }

    private static void providerPonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new OccultEngineeringPonderPlugin());
        PonderIndex.getLangAccess().provideLang("occultengineering", consumer);
    }
}

