/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritFireRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.simibubi.create.AllBlocks;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlocks;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringFluids;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class GettingStartedCategory
extends CategoryProvider {
    public static final String CATEGORY_ID = "getting_started";

    public GettingStartedCategory(BookProvider parent) {
        super(parent, CATEGORY_ID);
    }

    protected String[] generateEntryMap() {
        return new String[]{"__________________________________", "__________________________________", "_____i__b_________________________", "__________________________________", "_____S_\u0107_____e____________________", "________M____\u00fa___H________________", "_____g__P_________________________", "________D____&___?________________", "__________________________________"};
    }

    protected void generateEntries() {
        BookEntryModel intro = this.add(this.makeIntroEntry(this.entryMap, 'i'));
        BookEntryModel basics = this.add(this.makeBasicsEntry(this.entryMap, 'b'));
        basics.withParent(BookEntryParentModel.create((ResourceLocation)intro.getId()));
        BookEntryModel spiritSolution = this.add(this.makeSpiritSolutionEntry(this.entryMap, 'S'));
        spiritSolution.withParent(BookEntryParentModel.create((ResourceLocation)intro.getId()));
        BookEntryModel chalks = this.add(this.makeChalksEntry(this.entryMap, '\u0107'));
        chalks.withParent(BookEntryParentModel.create((ResourceLocation)spiritSolution.getId()));
        BookEntryModel sterlingSilver = this.add(this.makeSterlingSilverEntry(this.entryMap, 'g'));
        sterlingSilver.withParent(BookEntryParentModel.create((ResourceLocation)spiritSolution.getId()));
        BookEntryModel chamber = this.add(this.makeChamberEntry(this.entryMap, 'M'));
        chamber.withParent(BookEntryParentModel.create((ResourceLocation)sterlingSilver.getId()));
        BookEntryModel pulverizer = this.add(this.makePulverizerEntry(this.entryMap, 'P'));
        pulverizer.withParent(BookEntryParentModel.create((ResourceLocation)sterlingSilver.getId()));
        BookEntryModel detector = this.add(this.makeDetectorEntry(this.entryMap, 'D'));
        detector.withParent(BookEntryParentModel.create((ResourceLocation)sterlingSilver.getId()));
        BookEntryModel phlogiston = this.add(this.makePhlogistonEntry(this.entryMap, '&'));
        phlogiston.withParent(BookEntryParentModel.create((ResourceLocation)sterlingSilver.getId()));
        BookEntryModel silverPhlogistate = this.add(this.makeSilverPhlogistateEntry(this.entryMap, '?'));
        silverPhlogistate.withParent(BookEntryParentModel.create((ResourceLocation)phlogiston.getId()));
        BookEntryModel phlogiport = this.add(this.makePhlogiportEntry(this.entryMap, 'H'));
        phlogiport.withParent(BookEntryParentModel.create((ResourceLocation)silverPhlogistate.getId()));
        BookEntryModel pucaBook = this.add(this.makePucaBookEntry(this.entryMap, '\u00fa'));
        pucaBook.withParent(BookEntryParentModel.create((ResourceLocation)chamber.getId()));
        BookEntryModel pentacles = this.add(this.makePentaclesLinkEntry(this.entryMap, 'e'));
        pentacles.withParent(BookEntryParentModel.create((ResourceLocation)chamber.getId()));
    }

    protected BookCategoryModel generateCategory() {
        this.add(this.context().categoryName(), "Getting Started");
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon(OccultEngineeringItems.ENCYCLOPEDIA_OF_SOULS).withShowCategoryButton(true);
    }

    private BookEntryModel makeIntroEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "intro";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "About");
        this.lang().add(this.context().entryDescription(), "About using the Encyclopedia");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "About");
        this.lang().add(this.context().pageText(), "This book aims to introduce the new functionality of Occult Engineering,\nand aims to complement the Ponder system of the Kinetic Blocks, adding info about the other features.\n");
        this.context().page("help");
        BookTextPageModel help = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Getting Help");
        this.lang().add(this.context().pageText(), "If you run into any trouble with Occult Engineering, feel free to join the Discord to get help.\n\\\n\\\n[Join at https://discord.gg/B7Sd3eaTrs](https://discord.gg/B7Sd3eaTrs)\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringItems.ENCYCLOPEDIA_OF_SOULS).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, help});
    }

    private BookEntryModel makeBasicsEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "basics";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Basics");
        this.lang().add(this.context().entryDescription(), "Simple interactions between Create & Occultism");
        this.context().page("new_recipes");
        BookTextPageModel newRecipes = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "New Recipes");
        this.lang().add(this.context().pageText(), "Occult Engineering contains a bunch of new recipes to assist the creation of occult items.\n\\\n\\\nFor one, the mixer can now be used to mix up all the books of binding from Occultism.\n");
        this.context().page("new_recipes2");
        BookTextPageModel newRecipes2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.lang().add(this.context().pageText(), "Don't have enough silver? Raw Gold can be haunted into Raw Silver.\n\\\n\\\nCheck JEI for the specific recipes.\n");
        this.context().page("new_fan_catalyst");
        BookSpotlightPageModel newFanCatalyst = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllBlocks.ENCASED_FAN})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Encased Fan & Spiritfire");
        this.lang().add(this.context().pageText(), "Spiritfire and the Spirit Campfire can now be used in front of an encased fan to 'Bulk Enspirit'\nitems. This can be used to automate all of the Spiritfire's recipes.\n");
        this.context().page("new_arm_interaction");
        BookSpotlightPageModel newArmInteraction = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllBlocks.MECHANICAL_ARM})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "The Mechanical Arm");
        this.lang().add(this.context().pageText(), "The Mechanical Arm has new targets!\n\\\n\\\nIt can directly interact with the Sacrificial Bowl, the Stable Wormhole and the Dimensional Storage\nActuator.\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)AllBlocks.COGWHEEL).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 2).withPages(new BookPageModel[]{newRecipes, newRecipes2, newFanCatalyst, newArmInteraction});
    }

    private BookEntryModel makeSpiritSolutionEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "spirit_solution";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Spirit Solution");
        this.lang().add(this.context().entryDescription(), "The essential elixir");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultEngineeringFluids.SPIRIT_SOLUTION.getBucket().get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Spirit Solution");
        this.lang().add(this.context().pageText(), "Spirit Solution is used for a number of things in the mod. Most notably, it can be poured onto books\nof binding to bind them ready for a ritual which can be used in place of  of crafting with a Dictionary of Spirits.\n\\\nIt is also used as the only way to craft the new chalks.\n");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.lang().add(this.context().pageText(), "To get started with a small bit of Spirit Solution, crush some Demon's Dream Seeds.\n\\\nUse standard Create machinery to pump it around, or collect it in a bucket when you have enough.\n\\\nTo get the solution more efficiently, Water can either be mixed with Demon's Dream Fruit or\nOtherworld Essence with heat applied.\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultEngineeringFluids.SPIRIT_SOLUTION.getBucket().get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel makeChalksEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "chalks";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "New Chalks");
        this.lang().add(this.context().entryDescription(), "Fancier symbols to decorate the ground");
        this.context().page("chalks");
        BookTextPageModel chalks = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "More Chalks");
        this.lang().add(this.context().pageText(), "Along with Occultism's standard chalk, you may need to end up crafting 3 new types of chalk.\n\\\n\\\nThe cost of the chalk scales with the cost of the ritual, with Copper being the cheapest, then Zinc and\nfinally Brass.\n");
        this.context().page("chalks2");
        BookTextPageModel chalks2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.lang().add(this.context().pageText(), "The new chalks can only be crafted by pressing them with [Spirit Solution](entry://occultengineering:encyclopedia_of_souls/getting_started/spirit_solution).\n\\\n\\\nThe more expensive the chalk, the more spirit solution that they require.\n");
        this.context().page("purify_copper");
        BookSpiritFireRecipePageModel purify_copper = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_copper"))).withTitle1(this.context().pageTitle())).build();
        this.lang().add(this.context().pageTitle(), "Copper Chalk");
        this.context().page("purify_zinc");
        BookSpiritFireRecipePageModel purify_zinc = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_zinc"))).withTitle1(this.context().pageTitle())).build();
        this.lang().add(this.context().pageTitle(), "Zinc Chalk");
        this.context().page("purify_brass");
        BookSpiritFireRecipePageModel purify_brass = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_brass"))).withTitle1(this.context().pageTitle())).build();
        this.lang().add(this.context().pageTitle(), "Brass Chalk");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringItems.COPPER_CHALK).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{chalks, chalks2, purify_copper, purify_zinc, purify_brass});
    }

    private BookEntryModel makeSterlingSilverEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "sterling_silver";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Sterling Silver");
        this.lang().add(this.context().entryDescription(), "A new versatile material");
        this.context().page("sterling_silver");
        BookSpotlightPageModel sterlingSilver = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringItems.STERLING_SILVER_INGOT})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Sterling Silver");
        this.lang().add(this.context().pageText(), "Sterling Silver is a new crafting material that can be used to craft Occult Machinery.\n\\\n\\\nCraft it by mixing Copper Dust and Silver Dust in a heated basin.\n");
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "- [*Mechanical Chamber*](entry://occultengineering:encyclopedia_of_souls/getting_started/mechanical_chamber)\n- [*Mechanical Pulverizer*](entry://occultengineering:encyclopedia_of_souls/getting_started/mechanical_pulverizer)\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringItems.STERLING_SILVER_INGOT).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{sterlingSilver, uses});
    }

    private BookEntryModel makePhlogistonEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "phlogiston";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Phlogiston");
        this.lang().add(this.context().entryDescription(), "The raw essence of fire");
        this.context().page("phlogiston");
        BookSpotlightPageModel phlogiston = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringItems.PHLOGISTON})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Sterling Silver");
        this.lang().add(this.context().pageText(), "Phlogiston is the element of fire which is a component of everything that burns.\nIt also interacts with Sterling Silver, weirdly.\n\\\n\\\nCraft it by compacting Afrit Essence with Lava\n");
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "- [*Silver Phlogistate*](entry://occultengineering:encyclopedia_of_souls/getting_started/silver_phlogistate)\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringItems.PHLOGISTON).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{phlogiston, uses});
    }

    private BookEntryModel makeSilverPhlogistateEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "silver_phlogistate";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Silver Phlogistate");
        this.lang().add(this.context().entryDescription(), "New & Improved");
        this.context().page("silver_phlogistate");
        BookSpotlightPageModel silverPhlogistate = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringItems.SILVER_PHLOGISTATE})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Silver Phlogistate");
        this.lang().add(this.context().pageText(), "Silver Phlogistate is used to craft Occult Technologies that don't require rotational power.\n\\\n\\\nCraft it by mixing Phlogiston and Sterling Silver\n");
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "- [*Phlogiport*](entry://occultengineering:encyclopedia_of_souls/getting_started/phlogiport)\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringItems.SILVER_PHLOGISTATE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{silverPhlogistate, uses});
    }

    private BookEntryModel makeChamberEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "mechanical_chamber";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Mechanical Chamber");
        this.lang().add(this.context().entryDescription(), "The height of ritual automation");
        this.context().page("mechanical_chamber");
        BookSpotlightPageModel mechanicalChamber = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringBlocks.MECHANICAL_CHAMBER})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Mechanical Chamber");
        this.lang().add(this.context().pageText(), "The Mechanical Chamber can be used in place of the Golden Sacrificial Bowl for any ritual that does not require item use\nor sacrifice.\n\\\n\\\nIt works best with the rituals that produce items.\n\\\n\\\nFor more info, ponder the block.\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_mechanical_chamber"))).build();
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringBlocks.MECHANICAL_CHAMBER).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{mechanicalChamber, ritual});
    }

    private BookEntryModel makePulverizerEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "mechanical_pulverizer";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Mechanical Pulverizer");
        this.lang().add(this.context().entryDescription(), "Dust galore!");
        this.context().page("mechanical_pulverizer");
        BookSpotlightPageModel mechanicalPulverizer = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringBlocks.MECHANICAL_PULVERIZER})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Mechanical Pulverizer");
        this.lang().add(this.context().pageText(), "The Mechanical Chamber can be used instead of Occultism's crushing for any item a spirit can crush.\n\\\n\\\nFor more info ponder the block.\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withIcon(OccultEngineeringBlocks.MECHANICAL_PULVERIZER).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{mechanicalPulverizer});
    }

    private BookEntryModel makeDetectorEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "otherworld_detector";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Otherworld Detector");
        this.lang().add(this.context().entryDescription(), "It knows when you're awake");
        this.context().page("otherworld_detector");
        BookSpotlightPageModel otherworldDetector = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringBlocks.OTHERWORLD_DETECTOR})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Otherworld Detector");
        this.lang().add(this.context().pageText(), "An Otherworld Detector can be used to detect whether the nearest player can see into the otherworld.\n\\\n\\\nIt outputs a redstone signal if they can.\n\\\n\\\nFor more info ponder the block.\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringBlocks.OTHERWORLD_DETECTOR).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{otherworldDetector});
    }

    private BookEntryModel makePhlogiportEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "phlogiport";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Phlogiport");
        this.lang().add(this.context().entryDescription(), "Move over, delivery drones!");
        this.context().page("phlogiport");
        BookSpotlightPageModel otherworldDetector = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringBlocks.PHLOGIPORT})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Phlogiport");
        this.lang().add(this.context().pageText(), "Phlogiports can be use to wirelessly transmit packages based on their address.\n\\\n\\\nClick it to open the inventory.\n\\\n\\\nFor more info ponder the block.\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringBlocks.PHLOGIPORT).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{otherworldDetector});
    }

    private BookEntryModel makePucaBookEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "puca_book";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "The P\u00faca");
        this.lang().add(this.context().entryDescription(), "A new spirit fascinated with machinery");
        this.context().page("puca");
        BookSpotlightPageModel puca = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{OccultEngineeringItems.BOOK_OF_BINDING_PUCA})).withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "The P\u00faca");
        this.lang().add(this.context().pageText(), "The P\u00faca is a new spirit that can be used to perform new rituals.\n\\\n\\\nIts not very harmful, so it doesn't require large pentacles to contain it.\n\\\n\\\nThey are primarily used for crafting machines.\n");
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Used to Craft");
        this.lang().add(this.context().pageText(), "- [*Otherworld Detector*](entry://occultengineering:encyclopedia_of_souls/getting_started/otherworld_detector)\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(OccultEngineeringItems.BOOK_OF_BINDING_PUCA).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{puca, uses});
    }

    private BookEntryModel makePentaclesLinkEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("pentacles_link");
        this.lang().add(this.context().entryName(), "Go to Pentacles");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withCategoryToOpen(this.modLoc("pentacles")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 2);
    }

    private ResourceLocation fullyQualifiedEntryId() {
        return this.modLoc(this.context().categoryId() + "/" + this.context().entryId());
    }
}

