/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.pucalith;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithMenu;
import io.github.irishgreencitrus.occultengineering.content.fluid.FilteredFluidTankBehaviour;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleMaterialChecklist;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentaclePrinter;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleSchematic;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringTags;
import java.util.LinkedHashSet;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PucalithBlockEntity
extends SmartBlockEntity
implements MenuProvider,
IInteractionChecker,
IHaveGoggleInformation {
    public static final int NEIGHBOUR_CHECK_MAX = 100;
    public State state;
    public PucalithInventory inventory = new PucalithInventory();
    private SmartFluidTankBehaviour internalTank;
    public PentaclePrinter printer = new PentaclePrinter();
    public PentacleSchematic schematic;
    public PentacleSchematic.ParseResult schematicParseResult;
    public int printerCooldown;
    public PentacleMaterialChecklist checklist = new PentacleMaterialChecklist();
    public boolean sendUpdate = false;
    public boolean shouldUpdateChecklist = false;
    public int neighborCheckCooldown = 0;
    public BlockPos previousTarget;
    public boolean hasCreativeCrate = false;
    public LinkedHashSet<LazyOptional<IItemHandler>> attachedInventories = new LinkedHashSet();
    public final int MAX_TANK_CAPACITY_MB = 2000;
    private final String INVENTORY_TAG = "Inventory";
    private final String PUCA_UUID_TAG = "PucaUUID";
    private final String CURRENT_STATE_TAG = "CurrentState";

    public PucalithBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.internalTank.getPrimaryTank().getTotalUnits(0.0f);
        this.state = State.STOPPED;
    }

    public void tick() {
        boolean shouldTryAgain;
        super.tick();
        if (this.neighborCheckCooldown-- <= 0) {
            this.neighborCheckCooldown = 100;
            this.findInventories();
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.tickBookPrinter();
        for (int skipsLeft = 1000; skipsLeft >= 0 && (shouldTryAgain = this.tickPentaclePrinter()); --skipsLeft) {
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 6);
        }
    }

    protected void tickBookPrinter() {
        boolean outputFull;
        int clipboardIn = 2;
        int clipboardOut = 3;
        ItemStack schematicItem = this.inventory.getStackInSlot(0);
        ItemStack clipboard = this.inventory.extractItem(clipboardIn, 1, true);
        boolean bl = outputFull = this.inventory.getStackInSlot(clipboardOut).m_41613_() == this.inventory.getSlotLimit(clipboardOut);
        if (!this.printer.isInitialised()) {
            if (!schematicItem.m_41619_()) {
                Either<PentacleSchematic, PentacleSchematic.ParseResult> schem = PentacleSchematic.fromStack(this.f_58857_, schematicItem);
                schem.ifLeft(schematic -> {
                    this.schematic = schematic;
                    this.checklist = new PentacleMaterialChecklist();
                    this.checklist.require(schematic.getItemRequirement());
                    this.printer.initialise((PentacleSchematic)schematic);
                });
            }
            return;
        }
        if (clipboard.m_41619_() || outputFull) {
            this.shouldUpdateChecklist = true;
            return;
        }
        if (this.shouldUpdateChecklist) {
            this.updateChecklist();
        }
        this.shouldUpdateChecklist = false;
        ItemStack extractedItem = this.inventory.extractItem(clipboardIn, 1, false);
        ItemStack stack = AllBlocks.CLIPBOARD.isIn(extractedItem) ? this.checklist.createWrittenClipboard() : this.checklist.createWrittenBook();
        stack.m_41764_(this.inventory.getStackInSlot(clipboardOut).m_41613_() + 1);
        this.inventory.setStackInSlot(clipboardOut, stack);
    }

    public void updateChecklist() {
        this.checklist.clear();
        if (this.schematic == null) {
            return;
        }
        if (this.printer.isInitialised()) {
            this.checklist.require(this.printer.getStillToPlaceRequrement());
        } else {
            this.checklist.require(this.schematic.getItemRequirement());
        }
        this.findInventories();
        for (LazyOptional lazyOptional : this.attachedInventories) {
            if (!lazyOptional.isPresent()) continue;
            IItemHandler inventory = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stack = inventory.getStackInSlot(slot);
                if (inventory.extractItem(slot, 1, true).m_41619_()) continue;
                this.checklist.collect(stack);
            }
        }
        this.sendUpdate = true;
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (Direction face : Iterate.directions) {
            LazyOptional itemHandler;
            BlockPos rel = this.f_58858_.m_121945_(face);
            if (this.f_58857_ == null || !this.f_58857_.m_46749_(rel)) continue;
            if (AllBlocks.CREATIVE_CRATE.has(this.f_58857_.m_8055_(rel))) {
                this.hasCreativeCrate = true;
                return;
            }
            BlockEntity be = this.f_58857_.m_7702_(rel);
            if (be == null || !(itemHandler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, face.m_122424_())).isPresent()) continue;
            this.attachedInventories.add((LazyOptional<IItemHandler>)itemHandler);
        }
    }

    protected boolean tickPentaclePrinter() {
        assert (this.f_58857_ != null);
        assert (!this.f_58857_.m_5776_());
        ItemStack blueprintItem = this.inventory.getStackInSlot(0);
        if (blueprintItem.m_41619_() && this.state != State.STOPPED && this.inventory.getStackInSlot(1).m_41619_()) {
            this.state = State.STOPPED;
            this.sendUpdate = true;
            return false;
        }
        if (this.state == State.STOPPED) {
            if (this.printer.isInitialised()) {
                this.resetPrinter();
            }
            return false;
        }
        if (!this.printer.isInitialised()) {
            this.initPrinter(blueprintItem);
            return false;
        }
        if (!this.f_58857_.m_46749_(this.schematic.position)) {
            return false;
        }
        if (this.printerCooldown-- > 0) {
            return false;
        }
        if (this.getTankRemaining() <= 0) {
            return false;
        }
        if (!this.printer.hasNextPlace()) {
            return false;
        }
        Pair<BlockPos, Either<BlockState, TagKey<Block>>> nextToPlace = this.printer.popNextToPlace();
        OccultEngineering.LOGGER.warn("Placing {} next", (Object)nextToPlace.toString());
        if (((Either)nextToPlace.getSecond()).left().isEmpty()) {
            return false;
        }
        BlockPos pos = (BlockPos)nextToPlace.getFirst();
        BlockState state = (BlockState)((Either)nextToPlace.getSecond()).left().orElseThrow();
        this.printerCooldown = 20;
        ItemRequirement requirement = this.printer.getStillToPlaceRequrement();
        this.sendUpdate = true;
        return false;
    }

    protected void initPrinter(ItemStack stack) {
        Either<PentacleSchematic, PentacleSchematic.ParseResult> schem = PentacleSchematic.fromStack(this.f_58857_, stack);
        this.sendUpdate = true;
        if (schem.left().isEmpty()) {
            this.state = State.STOPPED;
            this.schematicParseResult = (PentacleSchematic.ParseResult)((Object)schem.right().orElseThrow());
            return;
        }
        this.schematic = (PentacleSchematic)schem.left().get();
        this.printer.initialise(this.schematic);
        this.state = State.PAUSED;
        this.schematicParseResult = PentacleSchematic.ParseResult.OK;
    }

    public void resetPrinter() {
        this.printer.deinit();
        this.checklist.clear();
        this.schematic = null;
    }

    public void onPlayButton() {
        this.state = State.RUNNING;
    }

    public void onPauseButton() {
        this.state = State.PAUSED;
    }

    public void onStopButton() {
        this.state = State.STOPPED;
    }

    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        if (tag.m_128441_("CurrentState")) {
            this.state = State.valueOf(tag.m_128461_("CurrentState"));
        }
        super.read(tag, clientPacket);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128359_("CurrentState", this.state.toString());
        super.write(tag, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.internalTank = FilteredFluidTankBehaviour.single(fluidStack -> fluidStack.getFluid().m_205067_(OccultEngineeringTags.PUCALITH_FUEL), this, 2000).allowInsertion().forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.internalTank);
    }

    public int getTankRemaining() {
        if (this.hasCreativeCrate) {
            return this.getTankCapacity();
        }
        return (int)this.internalTank.getPrimaryTank().getTotalUnits(0.0f);
    }

    public int getTankCapacity() {
        return 2000;
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return PucalithMenu.create(i, inventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.UP && this.isFluidHandlerCap(cap)) {
            return this.internalTank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    public class PucalithInventory
    extends ItemStackHandler {
        public PucalithInventory() {
            super(4);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PucalithBlockEntity.this.m_6596_();
        }
    }

    public static enum State {
        STOPPED,
        PAUSED,
        RUNNING;

    }
}

