/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen.recipe;

import com.simibubi.create.AllTags;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class OcEngRecipeProvider
extends RecipeProvider {
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public OcEngRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.all.forEach(c -> c.register(finishedRecipeConsumer));
        Logger logger = OccultEngineering.LOGGER;
        String name = "Create: Occult Engineering";
        logger.info("{} registered {} recipe{}", new Object[]{name, this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(Consumer<FinishedRecipe> var1);
    }

    protected static class I {
        protected I() {
        }

        static TagKey<Item> copper() {
            return Tags.Items.INGOTS_COPPER;
        }

        static TagKey<Item> silverDust() {
            return AllTags.forgeItemTag((String)"dusts/silver");
        }

        static TagKey<Item> copperDust() {
            return AllTags.forgeItemTag((String)"dusts/copper");
        }

        static TagKey<Item> zincDust() {
            return AllTags.forgeItemTag((String)"dusts/zinc");
        }

        static TagKey<Item> brassDust() {
            return AllTags.forgeItemTag((String)"dusts/brass");
        }

        static TagKey<Item> sterlingNugget() {
            return AllTags.forgeItemTag((String)"nuggets/sterling_silver");
        }

        static TagKey<Item> sterlingIngot() {
            return AllTags.forgeItemTag((String)"ingots/sterling_silver");
        }

        static TagKey<Item> sterlingBlock() {
            return AllTags.forgeItemTag((String)"storage_blocks/sterling_silver");
        }
    }

    protected static class Marker {
        protected Marker() {
        }
    }
}

