/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber;

import com.klikli_dev.occultism.common.item.DummyTooltipItem;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.RitualProcessorBehaviour;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalChamberBlockEntity
extends KineticBlockEntity {
    @Nullable
    private RitualProcessorBehaviour processorBehaviour;
    public ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        private ItemStack handleDummyInsert(int slot, @NotNull ItemStack stack, boolean simulate) {
            Item item;
            ItemStack insertResult = super.insertItem(slot, stack, simulate);
            ItemStack activationItemStack = this.getStackInSlot(0);
            if (!simulate && insertResult.getCount() != stack.getCount() && (item = stack.getItem()) instanceof DummyTooltipItem) {
                DummyTooltipItem activationItem = (DummyTooltipItem)item;
                activationItem.performRitual(MechanicalChamberBlockEntity.this.level, MechanicalChamberBlockEntity.this.getBlockPos(), null, null, activationItemStack);
                activationItemStack.shrink(1);
            }
            return insertResult;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            long time;
            long timeSinceLastFail;
            if (MechanicalChamberBlockEntity.this.level == null || MechanicalChamberBlockEntity.this.processorBehaviour == null) {
                return stack;
            }
            if (stack.getItem() instanceof DummyTooltipItem) {
                return this.handleDummyInsert(slot, stack, simulate);
            }
            if (MechanicalChamberBlockEntity.this.processorBehaviour.isRitualActive()) {
                return stack;
            }
            if (MechanicalChamberBlockEntity.this.lastFailedCheck >= 0L && (timeSinceLastFail = (time = MechanicalChamberBlockEntity.this.level.getGameTime()) - MechanicalChamberBlockEntity.this.lastFailedCheck) < 100L) {
                return stack;
            }
            RecipeHolder ritualRecipe = MechanicalChamberBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> ((RitualRecipe)r.value()).matches(MechanicalChamberBlockEntity.this.level, MechanicalChamberBlockEntity.this.getBlockPos(), stack)).findFirst().orElse(null);
            if (ritualRecipe == null) {
                MechanicalChamberBlockEntity.this.lastFailedCheck = MechanicalChamberBlockEntity.this.level.getGameTime();
                return stack;
            }
            ItemStack insertResult = super.insertItem(slot, stack, simulate);
            ItemStack activationStack = this.getStackInSlot(0);
            if (!simulate && ((RitualRecipe)ritualRecipe.value()).getRitual().isValid(MechanicalChamberBlockEntity.this.level, MechanicalChamberBlockEntity.this.getBlockPos(), null, null, activationStack, (List)((RitualRecipe)ritualRecipe.value()).getIngredients())) {
                MechanicalChamberBlockEntity.this.processorBehaviour.startRitual(null, activationStack, (RecipeHolder<RitualRecipe>)ritualRecipe);
            }
            return insertResult;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            if (MechanicalChamberBlockEntity.this.level == null) {
                return;
            }
            MechanicalChamberBlockEntity.this.notifyUpdate();
            MechanicalChamberBlockEntity.this.lastChangeTime = MechanicalChamberBlockEntity.this.level.getGameTime();
        }
    };
    public long lastFailedCheck = -1L;
    public long lastChangeTime = 0L;

    public MechanicalChamberBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)OccultEngineeringBlockEntities.MECHANICAL_CHAMBER.get(), (be, ctx) -> be.itemStackHandler);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processorBehaviour = new RitualProcessorBehaviour((SmartBlockEntity)this, () -> this.itemStackHandler, () -> {
            int calc = (int)(Math.abs(this.getSpeed()) / 32.0f);
            return calc <= 0 ? 1 : calc;
        });
        behaviours.add(this.processorBehaviour);
    }

    public Optional<RecipeHolder<RitualRecipe>> getRitualFor(Level pLevel, ItemStack stack) {
        if (this.level == null || this.processorBehaviour == null) {
            return Optional.empty();
        }
        RecipeHolder ritualRecipe = pLevel.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> ((RitualRecipe)r.value()).matches(pLevel, this.getBlockPos(), stack)).findFirst().orElse(null);
        return Optional.ofNullable(ritualRecipe);
    }
}

