/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;

public class PentacleHelper {
    private PentacleHelper() {
    }

    public static boolean helpWithPentacle(Level level, BlockPos pos, Player player) {
        Map<BlockPos, Block> pentacleDiff = null;
        Map<BlockPos, Block> bestPentacleDiff = null;
        boolean hasPentacle = false;
        List<Multiblock> pentacleMultiblocks = level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().map(r -> ((RitualRecipe)r.value()).getPentacleId()).distinct().map(arg_0 -> ((ModonomiconAPI)ModonomiconAPI.get()).getMultiblock(arg_0)).toList();
        Multiblock bestMatch = null;
        for (Multiblock pentacle : pentacleMultiblocks) {
            pentacleDiff = PentacleHelper.getDifference(pentacle, level, pos);
            if (bestPentacleDiff != null && bestPentacleDiff.size() <= pentacleDiff.size()) continue;
            if (pentacleDiff.isEmpty()) {
                hasPentacle = true;
                continue;
            }
            bestPentacleDiff = pentacleDiff;
            bestMatch = pentacle;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty() && bestPentacleDiff.size() < 10) {
            player.displayClientMessage((Component)Component.translatable((String)"ritual.occultism.pentacle_help", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)bestMatch.getId())), PentacleHelper.pentacleDiffToComponent(bestPentacleDiff)}), false);
            return true;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty() && !hasPentacle) {
            player.displayClientMessage((Component)Component.translatable((String)"ritual.occultism.pentacle_help.no_pentacle"), false);
            return true;
        }
        return false;
    }

    public static MutableComponent pentacleDiffToComponent(Map<BlockPos, Block> bestPentacleDiff) {
        MutableComponent text = Component.literal((String)"");
        for (Map.Entry<BlockPos, Block> entry : bestPentacleDiff.entrySet()) {
            text.append((Component)Component.translatable((String)entry.getValue().getDescriptionId()));
            text.append((Component)Component.translatable((String)"ritual.occultism.pentacle_help_at_glue"));
            BlockPos pos = entry.getKey();
            text.append((Component)Component.literal((String)("x: " + pos.getX() + ", y: " + pos.getY() + ", z: " + pos.getZ() + "\n")));
        }
        return text;
    }

    public static boolean helpWithRitual(Level level, BlockPos pos, ServerPlayer player, ItemStack activationItem) {
        ArrayList ritualDiff = null;
        ArrayList bestRitualDiff = null;
        RitualRecipe bestRitual = null;
        Stream<Multiblock> pentacleMultiblocks = level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().map(r -> ((RitualRecipe)r.value()).getPentacleId()).distinct().map(arg_0 -> ((ModonomiconAPI)ModonomiconAPI.get()).getMultiblock(arg_0));
        List<Multiblock> pentacle = pentacleMultiblocks.filter(p -> p.validate(level, pos) != null).toList();
        if (pentacle.isEmpty()) {
            return false;
        }
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get())) {
            if (!pentacle.contains(((RitualRecipe)recipe.value()).getPentacle())) continue;
            ritualDiff = new ArrayList(((RitualRecipe)recipe.value()).getIngredients());
            List items = ((RitualRecipe)recipe.value()).getRitual().getItemsOnSacrificialBowls(level, pos);
            boolean found = false;
            for (int i = ritualDiff.size() - 1; i >= 0; --i) {
                found = false;
                for (int j = 0; j < items.size(); ++j) {
                    if (!((Ingredient)ritualDiff.get(i)).test((ItemStack)items.get(j))) continue;
                    items.remove(j);
                    found = true;
                    break;
                }
                if (!found) continue;
                ritualDiff.remove(i);
            }
            if (bestRitualDiff != null && bestRitualDiff.size() <= ritualDiff.size()) continue;
            bestRitualDiff = ritualDiff;
            bestRitual = (RitualRecipe)recipe.value();
        }
        if (bestRitualDiff != null && !bestRitualDiff.isEmpty() && bestRitualDiff.size() < 3) {
            player.displayClientMessage((Component)Component.translatable((String)"ritual.occultism.ritual_help", (Object[])new Object[]{Component.translatable((String)bestRitual.getRitual().getStartedMessage(player)), PentacleHelper.ritualDiffToComponent(bestRitualDiff)}), false);
            return true;
        }
        return false;
    }

    public static Object ritualDiffToComponent(List<Ingredient> ritualDiff) {
        Random rand = new Random();
        MutableComponent text = Component.literal((String)"");
        for (Ingredient ingredient : ritualDiff) {
            if (ingredient.getItems().length == 0) continue;
            text.append(ingredient.getItems()[rand.nextInt(ingredient.getItems().length)].getDisplayName());
            text.append("\n");
        }
        return text;
    }

    public static Map<BlockPos, Block> getDifference(Multiblock multiblock, Level level, BlockPos pos) {
        HashMap<BlockPos, Block> minDifference = new HashMap<BlockPos, Block>();
        int minDiffSize = Integer.MAX_VALUE;
        for (Rotation rot : Rotation.values()) {
            HashMap<BlockPos, Block> difference = new HashMap<BlockPos, Block>();
            Pair sim = multiblock.simulate(level, pos, rot, false, false);
            for (Multiblock.SimulateResult result : (Collection)sim.getSecond()) {
                if (result.test(level, rot)) continue;
                difference.put(result.getWorldPosition(), result.getStateMatcher().getDisplayedState(0L).getBlock());
            }
            if (difference.size() >= minDiffSize) continue;
            minDifference = difference;
            minDiffSize = difference.size();
        }
        return minDifference;
    }
}

