/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.pucalith;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithBlockEntity;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithMenu;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.packet.PucalithSendOptionPacket;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlocks;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringGuiTextures;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PucalithScreen
extends AbstractSimiContainerScreen<PucalithMenu> {
    protected OccultEngineeringGuiTextures background;
    private final ItemStack renderedItem = OccultEngineeringBlocks.PUCALITH.asStack();
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton stopButton;
    private IconButton playPauseButton;
    private IconButton exitCheckmarkButton;

    public PucalithScreen(PucalithMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.background = OccultEngineeringGuiTextures.PUCALITH;
    }

    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 8);
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        this.stopButton = new IconButton(x + 91, y + 73, (ScreenElement)AllIcons.I_STOP);
        this.stopButton.withCallback(() -> this.sendStateUpdate(PucalithSendOptionPacket.Option.STOP));
        this.playPauseButton = new IconButton(x + 110, y + 73, (ScreenElement)(((PucalithBlockEntity)((Object)((PucalithMenu)this.getMenu()).contentHolder)).state == PucalithBlockEntity.State.RUNNING ? AllIcons.I_PAUSE : AllIcons.I_PLAY));
        this.playPauseButton.withCallback(() -> {
            PucalithBlockEntity.State oldState = ((PucalithBlockEntity)((Object)((Object)((PucalithMenu)this.getMenu()).contentHolder))).state;
            this.playPauseButton.setIcon((ScreenElement)(oldState == PucalithBlockEntity.State.RUNNING ? AllIcons.I_PLAY : AllIcons.I_PAUSE));
            this.sendStateUpdate(PucalithSendOptionPacket.Option.PLAY);
        });
        this.exitCheckmarkButton = new IconButton(x + 159, y + 99, (ScreenElement)AllIcons.I_CONFIRM);
        this.exitCheckmarkButton.withCallback(() -> Objects.requireNonNull(this.getMinecraft().player).closeContainer());
        this.addRenderableWidgets((GuiEventListener[])new IconButton[]{this.playPauseButton, this.stopButton, this.exitCheckmarkButton});
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.getWidth(), y + this.background.getHeight() - 40, 48, 48));
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float v, int i, int i1) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.leftPos;
        int y = this.topPos;
        this.background.render(graphics, x, y);
        PucalithBlockEntity be = (PucalithBlockEntity)((Object)((PucalithMenu)this.menu).contentHolder);
        float amount = (float)be.getTankRemaining() / (float)be.getTankCapacity();
        this.renderFuelTank(graphics, x, y, amount);
        MutableComponent titleText = Component.translatable((String)"gui.occultengineering.pucalith.title");
        graphics.drawString(this.font, (Component)titleText, x + (this.background.getWidth() - 8 - this.font.width((FormattedText)titleText)) / 2, y + 4, 0x505050, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(x + this.background.getWidth()), (float)(y + this.background.getHeight() - 40), -200.0f)).scale(3.0).render(graphics);
    }

    private void renderFuelTank(GuiGraphics graphics, int x, int y, float amount) {
        OccultEngineeringGuiTextures sprite = OccultEngineeringGuiTextures.PUCALITH_FULL_TANK;
        if (((PucalithBlockEntity)((Object)((PucalithMenu)this.menu).contentHolder)).hasCreativeCrate) {
            sprite = OccultEngineeringGuiTextures.PUCALITH_CREATIVE_TANK;
        }
        int fillHeight = (int)Math.floor((float)sprite.getHeight() * amount);
        graphics.blit(sprite.location, x + 10, y + 22 + (sprite.getHeight() - fillHeight), sprite.getStartX(), sprite.getStartY() + (sprite.getHeight() - fillHeight), sprite.getWidth(), fillHeight);
    }

    protected void sendStateUpdate(PucalithSendOptionPacket.Option option) {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new PucalithSendOptionPacket(option));
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

