/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.registry;

import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.config.OcEngStress;
import io.github.irishgreencitrus.occultengineering.content.block.WrenchableBlock;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.MechanicalChamberBlock;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer.PulverizerBlock;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.OtherworldDetectorBlock;
import io.github.irishgreencitrus.occultengineering.content.block.pentacle_altar.PentacleAltarBlock;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.PhlogiportBlock;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithBlock;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringCreativeModeTab;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringDisplaySources;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class OccultEngineeringBlocks {
    public static final BlockEntry<MechanicalChamberBlock> MECHANICAL_CHAMBER;
    private static final BlockBehaviour.Properties GLYPH_PROPERTIES;
    public static final BlockEntry<ChalkGlyphBlock> COPPER_CHALK;
    public static final BlockEntry<ChalkGlyphBlock> ZINC_CHALK;
    public static final BlockEntry<ChalkGlyphBlock> BRASS_CHALK;
    public static final BlockEntry<OtherworldDetectorBlock> OTHERWORLD_DETECTOR;
    public static final BlockEntry<PulverizerBlock> MECHANICAL_PULVERIZER;
    public static final BlockEntry<Block> STERLING_SILVER_BLOCK;
    public static final BlockEntry<WrenchableBlock> FAN_ENSPIRIT_CATALYST;
    public static final BlockEntry<PentacleAltarBlock> PENTACLE_ALTAR;
    public static final BlockEntry<PucalithBlock> PUCALITH;
    public static final BlockEntry<PhlogiportBlock> PHLOGIPORT;

    public static void genChalkGlyph(DataGenContext<Block, ChalkGlyphBlock> context, RegistrateBlockstateProvider blockstateProvider) {
        ModelFile.ExistingModelFile parentModel = blockstateProvider.models().getExistingFile(OccultEngineering.asResource("block/chalk_glyph"));
        blockstateProvider.getVariantBuilder((Block)context.get()).forAllStates(state -> {
            int sign = (Integer)state.getValue((Property)ChalkGlyphBlock.SIGN);
            String glyphLocation = "block/chalk_glyph/" + sign;
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)blockstateProvider.models().getBuilder(glyphLocation)).parent((ModelFile)parentModel)).texture("texture", glyphLocation);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        });
    }

    public static void register() {
    }

    static {
        OccultEngineering.REGISTRATE.setCreativeTab(OccultEngineeringCreativeModeTab.CREATIVE_TAB);
        MECHANICAL_CHAMBER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)OccultEngineering.REGISTRATE.block("mechanical_chamber", MechanicalChamberBlock::new).initialProperties(() -> Blocks.IRON_BLOCK).transform(b -> b.tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{OccultismTags.Blocks.CENTER_SACRIFICIAL_BOWL}))).properties(p -> p.mapColor(MapColor.COLOR_LIGHT_BLUE).noOcclusion()).blockstate(BlockStateGen.horizontalBlockProvider((boolean)false)).transform(OcEngStress.setImpact(4.0))).transform((NonNullFunction)DisplaySource.displaySource(OccultEngineeringDisplaySources.CURRENT_PENTACLE))).transform((NonNullFunction)DisplaySource.displaySource(OccultEngineeringDisplaySources.CURRENT_RITUAL_RESULT))).transform((NonNullFunction)DisplaySource.displaySource(OccultEngineeringDisplaySources.RITUAL_COMPLETION))).simpleItem().register();
        GLYPH_PROPERTIES = BlockBehaviour.Properties.of().sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY).replaceable().noCollission().strength(5.0f, 30.0f);
        COPPER_CHALK = OccultEngineering.REGISTRATE.block("copper_chalk", p -> new ChalkGlyphBlock(GLYPH_PROPERTIES, () -> 15437368, () -> OccultEngineeringItems.COPPER_CHALK.get())).blockstate(OccultEngineeringBlocks::genChalkGlyph).color(() -> () -> (state, world, pos, layer) -> 15437368).register();
        ZINC_CHALK = OccultEngineering.REGISTRATE.block("zinc_chalk", p -> new ChalkGlyphBlock(GLYPH_PROPERTIES, () -> 9623204, () -> OccultEngineeringItems.ZINC_CHALK.get())).blockstate(OccultEngineeringBlocks::genChalkGlyph).color(() -> () -> (state, world, pos, layer) -> 9623204).register();
        BRASS_CHALK = OccultEngineering.REGISTRATE.block("brass_chalk", p -> new ChalkGlyphBlock(GLYPH_PROPERTIES, () -> 16500309, () -> OccultEngineeringItems.BRASS_CHALK.get())).blockstate(OccultEngineeringBlocks::genChalkGlyph).color(() -> () -> (state, world, pos, layer) -> 16500309).register();
        OTHERWORLD_DETECTOR = ((BlockBuilder)OccultEngineering.REGISTRATE.block("otherworld_detector", OtherworldDetectorBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_CYAN)).properties(p -> p.isRedstoneConductor(($1, $2, $3) -> false)).blockstate((c, p) -> BlockStateGen.simpleBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> {
            boolean powered = (Boolean)s.getValue((Property)OtherworldDetectorBlock.POWERED);
            String name = c.getName() + (powered ? "_powered" : "");
            return p.models().cubeAll(name, p.modLoc("block/" + name));
        })).transform(TagGen.pickaxeOnly())).lang("Otherworld Detector").simpleItem().register();
        MECHANICAL_PULVERIZER = ((BlockBuilder)((BlockBuilder)OccultEngineering.REGISTRATE.block("mechanical_pulverizer", PulverizerBlock::new).initialProperties(SharedProperties::stone).transform(TagGen.pickaxeOnly())).properties(p -> p.mapColor(MapColor.COLOR_GRAY).noOcclusion()).blockstate(BlockStateGen.horizontalBlockProvider((boolean)false)).transform(OcEngStress.setImpact(4.0))).simpleItem().register();
        STERLING_SILVER_BLOCK = ((BlockBuilder)OccultEngineering.REGISTRATE.block("sterling_silver_block", Block::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).properties(p -> p.mapColor(MapColor.COLOR_GRAY)).lang("Block of Sterling Silver").simpleItem().register();
        FAN_ENSPIRIT_CATALYST = ((BlockBuilder)((BlockBuilder)OccultEngineering.REGISTRATE.block("fan_enspirit_catalyst", WrenchableBlock::new).initialProperties(() -> Blocks.IRON_BLOCK).properties(p -> p.mapColor(MapColor.TERRACOTTA_YELLOW).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((state, level, pos) -> false)).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).lang("Fan Enspirit Catalyst").item().transform(ModelGen.customItemModel())).register();
        PENTACLE_ALTAR = ((BlockBuilder)OccultEngineering.REGISTRATE.block("pentacle_altar", PentacleAltarBlock::new).initialProperties(SharedProperties::wooden).properties(p -> p.mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops()).transform(TagGen.axeOnly())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), (ModelFile)p.models().cubeBottomTop("pentacle_altar", p.modLoc("block/pentacle_altar_side"), p.modLoc("block/pentacle_altar_bottom"), p.modLoc("block/pentacle_altar_top")))).lang("Pentacle Altar").simpleItem().register();
        PUCALITH = ((BlockBuilder)OccultEngineering.REGISTRATE.block("pucalith", PucalithBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), (ModelFile)p.models().cubeBottomTop("pucalith", p.modLoc("block/pucalith_side"), p.modLoc("block/pucalith_bottom"), p.modLoc("block/pucalith_top")))).lang("P\u00facalith").simpleItem().register();
        PHLOGIPORT = ((BlockBuilder)OccultEngineering.REGISTRATE.block("phlogiport", PhlogiportBlock::new).initialProperties(SharedProperties::softMetal).transform(TagGen.pickaxeOnly())).properties(p -> p.noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).blockstate((c, p) -> p.simpleBlock((Block)c.get(), AssetLookup.standardModel((DataGenContext)c, (RegistrateBlockstateProvider)p))).lang("Phlogiport").simpleItem().register();
    }
}

