/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.occultism.common.ritual.CraftMinerSpiritRitual;
import com.klikli_dev.occultism.common.ritual.CraftRitual;
import com.klikli_dev.occultism.common.ritual.CraftWithSpiritNameRitual;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MechanicalChamberBlockEntity
extends KineticBlockEntity {
    @Nullable
    public RitualRecipe currentRitualRecipe;
    public ResourceLocation currentRitualRecipeId;
    public List<Ingredient> remainingIngredients = new ArrayList<Ingredient>();
    public List<ItemStack> consumedIngredients = new ArrayList<ItemStack>();
    public boolean sacrificeProvided;
    public boolean itemUseProvided;
    public int currentTime;
    public ItemStackHandler itemStackHandler;
    public LazyOptional<ItemStackHandler> lazyItemStackHandler = LazyOptional.of(() -> this.itemStackHandler);
    public long lastChangeTime;

    public MechanicalChamberBlockEntity(BlockEntityType<?> entityType, BlockPos worldPos, BlockState state) {
        super(entityType, worldPos, state);
        this.itemStackHandler = new ItemStackHandler(1){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                ItemStack insertResult = super.insertItem(slot, stack, simulate);
                if (MechanicalChamberBlockEntity.this.getCurrentRitualRecipe() != null) {
                    return insertResult;
                }
                MechanicalChamberBlockEntity self = MechanicalChamberBlockEntity.this;
                Level level = self.f_58857_;
                assert (level != null);
                RitualRecipe ritualRecipe = MechanicalChamberBlockEntity.this.getRitualFor(level, self.m_58899_(), stack, null).orElse(null);
                if (ritualRecipe == null) {
                    return insertResult;
                }
                if (!simulate && insertResult.m_41613_() != stack.m_41613_() && ritualRecipe.getRitual().areAdditionalIngredientsFulfilled(level, self.m_58899_(), (List)ritualRecipe.m_7527_())) {
                    self.startRitual(ritualRecipe);
                }
                return insertResult;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                MechanicalChamberBlockEntity self = MechanicalChamberBlockEntity.this;
                assert (self.f_58857_ != null);
                if (!((MechanicalChamberBlockEntity)self).f_58857_.f_46443_) {
                    self.lastChangeTime = MechanicalChamberBlockEntity.this.f_58857_.m_46467_();
                    MechanicalChamberBlockEntity.this.updateBlock();
                }
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemStackHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Nullable
    public RitualRecipe getCurrentRitualRecipe() {
        if (this.currentRitualRecipeId != null && this.f_58857_ != null) {
            RitualRecipe ritualRecipe;
            Object t;
            Optional recipe = this.f_58857_.m_7465_().m_44043_(this.currentRitualRecipeId);
            if (recipe.isPresent() && (t = recipe.get()) instanceof RitualRecipe && !(ritualRecipe = (RitualRecipe)t).requiresItemUse() && !ritualRecipe.requiresSacrifice()) {
                this.currentRitualRecipe = ritualRecipe;
            }
            this.currentRitualRecipeId = null;
        }
        return this.currentRitualRecipe;
    }

    public void startRitual(@NotNull RitualRecipe recipe) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return;
        }
        assert (recipe.getEntityToSummon() == null);
        assert (!recipe.requiresItemUse() && !recipe.requiresSacrifice());
        this.currentRitualRecipe = recipe;
        this.currentTime = 0;
        this.sacrificeProvided = false;
        this.itemUseProvided = false;
        this.consumedIngredients.clear();
        this.remainingIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.currentRitualRecipe.m_7527_());
        this.updateBlock();
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean activate(Level level, BlockPos blockPos, ItemStack activationItem) {
        if (level.f_46443_) {
            return true;
        }
        if (this.getCurrentRitualRecipe() != null) return true;
        Optional<RitualRecipe> ritualRecipe = this.getRitualFor(level, blockPos, activationItem, null);
        if (!ritualRecipe.isPresent()) return false;
        RitualRecipe recipe = ritualRecipe.get();
        if (!recipe.getRitual().areAdditionalIngredientsFulfilled(level, blockPos, (List)recipe.m_7527_())) return false;
        this.itemStackHandler.insertItem(0, activationItem.m_41620_(1), false);
        this.startRitual(recipe);
        return true;
    }

    public Optional<RitualRecipe> getRitualFor(Level level, BlockPos blockPos, ItemStack activationItem, @Nullable List<Ingredient> additionalIngredients) {
        return level.m_7465_().m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> this.isRitualValid((RitualRecipe)r, level, blockPos, activationItem, (List<Ingredient>)(additionalIngredients == null ? r.m_7527_() : additionalIngredients))).findFirst();
    }

    public boolean isRitualValid(RitualRecipe recipe, Level level, BlockPos centerPosition, ItemStack activationItem, List<Ingredient> additionalIngredients) {
        return recipe.getPentacle() != null && recipe.getActivationItem().test(activationItem) && recipe.getRitual().areAdditionalIngredientsFulfilled(level, centerPosition, additionalIngredients) && this.getPentacle(recipe, level, centerPosition) == recipe.getPentacle();
    }

    public Multiblock getPentacle(RitualRecipe recipe, Level level, BlockPos blockPos) {
        Multiblock pentacle = recipe.getPentacle();
        for (Rotation rotation : Rotation.values()) {
            Collection results = (Collection)pentacle.simulate(level, blockPos, rotation, false, false).getSecond();
            Multiblock pentacleCandidate = null;
            for (Multiblock.SimulateResult result : results) {
                StateMatcher stateMatcher = result.getStateMatcher();
                if (!stateMatcher.countsTowardsTotalBlocks()) continue;
                pentacleCandidate = pentacle;
                if (result.getWorldPosition().equals((Object)blockPos) || result.test(level, rotation)) continue;
                pentacleCandidate = null;
                break;
            }
            if (pentacleCandidate == null) continue;
            return pentacleCandidate;
        }
        return null;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isSpeedRequirementFulfilled()) {
            return;
        }
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (recipe == null) {
            return;
        }
        if (this.remainingIngredients == null) {
            this.restoreRemainingIngredients();
            if (this.remainingIngredients == null) {
                return;
            }
        }
        if (!this.isRitualValid(recipe, this.f_58857_, this.m_58899_(), this.itemStackHandler.getStackInSlot(0), this.remainingIngredients)) {
            this.stopRitual(false);
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            this.currentTime += this.getRitualSpeedMultiplier();
        }
        if (this.f_58857_.f_46441_.m_188503_(16) == 0) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)this.m_58899_().m_123341_() + 0.5 + this.f_58857_.f_46441_.m_188583_() / 3.0, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5 + this.f_58857_.f_46441_.m_188583_() / 3.0, 5, 0.0, 0.0, 0.0, 0.0);
        }
        if (!recipe.getRitual().consumeAdditionalIngredients(this.f_58857_, this.m_58899_(), this.remainingIngredients, this.currentTime, this.consumedIngredients)) {
            this.stopRitual(false);
            return;
        }
        if (this.currentTime >= recipe.getDuration()) {
            this.stopRitual(true);
        }
    }

    private int getRitualSpeedMultiplier() {
        int calc = (int)(Math.abs(this.getSpeed()) / 32.0f);
        return calc <= 0 ? 1 : calc;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean parent = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getCurrentRitualRecipe() != null) {
            LangBuilder builder = new LangBuilder("occultengineering");
            builder.translate("tooltip.ritualspeed", new Object[0]).text(" ").text(String.valueOf(this.getRitualSpeedMultiplier())).text("x").style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        return parent;
    }

    private void stopRitual(boolean ritualCompleted) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (recipe != null) {
            if (ritualCompleted) {
                ItemStack activationItem = this.itemStackHandler.getStackInSlot(0);
                if (recipe.getRitual() instanceof CraftRitual) {
                    activationItem.m_41774_(1);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
                    this.itemStackHandler.insertItem(0, result, false);
                } else if (recipe.getRitual() instanceof CraftWithSpiritNameRitual) {
                    ItemStack copy = activationItem.m_41777_();
                    activationItem.m_41774_(1);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
                    ItemNBTUtil.setBoundSpiritName((ItemStack)result, (String)ItemNBTUtil.getBoundSpiritName((ItemStack)copy));
                    this.itemStackHandler.insertItem(0, result, false);
                } else if (recipe.getRitual() instanceof CraftMinerSpiritRitual) {
                    ItemStack copy = activationItem.m_41777_();
                    activationItem.m_41774_(1);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
                    result.m_41720_().m_7836_(result, this.f_58857_, null);
                    ItemNBTUtil.setBoundSpiritName((ItemStack)result, (String)ItemNBTUtil.getBoundSpiritName((ItemStack)copy));
                    this.itemStackHandler.insertItem(0, result, false);
                } else {
                    recipe.getRitual().finish(this.f_58857_, this.m_58899_(), null, null, activationItem);
                }
            } else {
                Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.itemStackHandler.extractItem(0, 1, false));
            }
        }
        this.currentRitualRecipe = null;
        this.currentRitualRecipeId = null;
        this.currentTime = 0;
        if (this.remainingIngredients != null) {
            this.remainingIngredients.clear();
        }
        this.consumedIngredients.clear();
        this.updateBlock();
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
    }

    private void restoreRemainingIngredients() {
        assert (this.f_58857_ != null);
        RitualRecipe currentRecipe = this.getCurrentRitualRecipe();
        if (currentRecipe == null) {
            return;
        }
        this.remainingIngredients = !this.consumedIngredients.isEmpty() ? Ritual.getRemainingAdditionalIngredients((List)currentRecipe.m_7527_(), this.consumedIngredients) : new ArrayList<Ingredient>((Collection<Ingredient>)currentRecipe.m_7527_());
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("currentRitual")) {
            this.currentRitualRecipeId = new ResourceLocation(compound.m_128461_("currentRitual"));
        }
        this.consumedIngredients.clear();
        if (this.currentRitualRecipeId != null || this.getCurrentRitualRecipe() != null) {
            if (compound.m_128441_("consumedIngredients")) {
                ListTag list = compound.m_128437_("consumedIngredients", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                    this.consumedIngredients.add(stack);
                }
            }
            this.restoreRemainingIngredients();
        }
        this.lazyItemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("inventory")));
        this.lastChangeTime = compound.m_128454_("lastChangeTime");
        this.currentTime = compound.m_128451_("currentTime");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (recipe != null) {
            compound.m_128359_("currentRitual", recipe.m_6423_().toString());
            if (!this.consumedIngredients.isEmpty()) {
                ListTag list = new ListTag();
                for (ItemStack stack : this.consumedIngredients) {
                    list.add((Object)stack.serializeNBT());
                }
                compound.m_128365_("consumedIngredients", (Tag)list);
            }
        }
        compound.m_128356_("lastChangeTime", this.lastChangeTime);
        this.lazyItemStackHandler.ifPresent(handler -> compound.m_128365_("inventory", (Tag)handler.serializeNBT()));
        compound.m_128405_("currentTime", this.currentTime);
        super.write(compound, clientPacket);
    }

    private void updateBlock() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

