/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.entity.puca;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrain;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrainFactory;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrainSupplantable;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.brain.PucaBrain;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBrains;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringEntities;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PucaEntity
extends PathfinderMob
implements GeoEntity,
SmartBrainOwner<PucaEntity>,
DynamicBrainSupplantable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    protected PucaBrain dynamicBrain;
    @Nullable
    public BlockPos returnHomePosition;
    @Nullable
    public BlockPos nextTargetPos;
    @Nullable
    public BlockState nextBlockState;
    @NotNull
    public ItemStack heldItem = ItemStack.f_41583_;
    protected boolean hasJumped = false;
    protected static final EntityDataAccessor<String> DYNAMIC_BRAIN_ID = SynchedEntityData.m_135353_(PucaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public PucaEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public PucaEntity(Level level, ItemStack heldItem, BlockState stateToPlace, BlockPos pos) {
        this((EntityType)OccultEngineeringEntities.PUCA.get(), level);
        this.heldItem = heldItem;
    }

    public static PucaEntity genericPuca(EntityType<?> entityType, Level level) {
        PucaEntity e = new PucaEntity(entityType, level);
        e.supplantBrain(((DynamicBrainFactory)OccultEngineeringBrains.PUCA_WANDER.get()).create(e));
        return e;
    }

    public void jumpNow() {
        this.f_21343_.m_24901_();
        this.hasJumped = true;
        this.triggerAnim("main", "jump");
    }

    public boolean getHasJumped() {
        return this.hasJumped;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 1, this::animPredicate).triggerableAnim("jump", RawAnimation.begin().thenPlayAndHold("jump"))});
    }

    public PlayState animPredicate(AnimationState<PucaEntity> animState) {
        if (!((PucaEntity)animState.getAnimatable()).m_20096_()) {
            return PlayState.CONTINUE;
        }
        return animState.setAndContinue(RawAnimation.begin().thenPlay("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this, true);
    }

    public void handleAdditionalBrainSetup(SmartBrain<? extends PucaEntity> brain) {
        if (this.dynamicBrain != null) {
            this.dynamicBrain.onBrainSetup(brain);
        }
    }

    public List<? extends ExtendedSensor<? extends PucaEntity>> getSensors() {
        return this.dynamicBrain != null ? this.dynamicBrain.getSensors() : ImmutableList.of();
    }

    public BrainActivityGroup<PucaEntity> getCoreTasks() {
        return this.dynamicBrain != null ? this.dynamicBrain.getCoreTasks() : BrainActivityGroup.empty();
    }

    public BrainActivityGroup<PucaEntity> getIdleTasks() {
        return this.dynamicBrain != null ? this.dynamicBrain.getIdleTasks() : BrainActivityGroup.empty();
    }

    @Override
    public void supplantBrain(DynamicBrain<? extends LivingEntity> newBrain) {
        OccultEngineering.LOGGER.info("Supplanting {}", (Object)newBrain.brainID.toString());
        if (this.dynamicBrain != null) {
            this.dynamicBrain.onCleanup();
        }
        this.dynamicBrain = (PucaBrain)newBrain;
        this.remakeBrain();
    }

    public boolean dynamicBrainIs(ResourceLocation brainLoc) {
        if (this.dynamicBrain == null) {
            return false;
        }
        return this.dynamicBrain.brainID.equals((Object)brainLoc);
    }

    public void remakeBrain() {
        NbtOps nbtops = NbtOps.f_128958_;
        this.f_20939_ = this.m_8075_(new Dynamic((DynamicOps)nbtops, (Object)((Tag)nbtops.createMap((Map)ImmutableMap.of((Object)nbtops.createString("memories"), (Object)((Tag)nbtops.emptyMap()))))));
    }

    protected void m_8024_() {
        if (this.dynamicBrain != null) {
            this.dynamicBrain.tick();
        }
        this.tickBrain((LivingEntity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_()) {
            this.hasJumped = false;
        }
    }

    public void setReturnHomePosition(BlockPos position) {
        this.returnHomePosition = position;
    }

    public void setNextPlacePosition(BlockPos position, BlockState state, ItemStack heldItem) {
        this.nextTargetPos = position;
        this.nextBlockState = state;
        this.heldItem = heldItem;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return this.heldItem;
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.heldItem = itemStack;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DYNAMIC_BRAIN_ID, (Object)"");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.dynamicBrain != null) {
            compound.m_128359_("DynamicBrainID", this.dynamicBrain.brainID.toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        DynamicBrain<LivingEntity> brain;
        DynamicBrainFactory brainFactory;
        super.m_7378_(compound);
        if (compound.m_128441_("DynamicBrainID") && (brainFactory = (DynamicBrainFactory)OccultEngineeringBrains.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)compound.m_128461_("DynamicBrainID")))) != null && (brain = brainFactory.create((Entity)this)) != null) {
            this.supplantBrain(brain);
        }
    }
}

