/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.entity.puca.brain;

import com.mojang.datafixers.util.Pair;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlocks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.commons.lang3.function.TriFunction;

public class PlaceBlock<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    protected TriPredicate<E, BlockPos, BlockState> shouldPlaceNewBlock = (entity, pos, state) -> state.m_60713_(Blocks.f_50016_);
    protected TriFunction<E, BlockPos, BlockState, BlockState> stateToPlace = (entity, pos, state) -> OccultEngineeringBlocks.STERLING_SILVER_BLOCK.getDefaultState();
    protected BlockPos blockPos = null;
    protected BlockState newState = null;
    protected boolean hasPlacedBlock = false;

    public PlaceBlock<E> shouldPlaceIf(TriPredicate<E, BlockPos, BlockState> shouldPlaceNewBlock) {
        this.shouldPlaceNewBlock = shouldPlaceNewBlock;
        return this;
    }

    public PlaceBlock<E> stateToPlace(TriFunction<E, BlockPos, BlockState, BlockState> stateToPlace) {
        this.stateToPlace = stateToPlace;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (this.hasPlacedBlock) {
            return false;
        }
        for (Pair pair : (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()))) {
            if (!this.shouldPlaceNewBlock.test(entity, (Object)((BlockPos)pair.getFirst()), (Object)((BlockState)pair.getSecond()))) continue;
            this.blockPos = (BlockPos)pair.getFirst();
            this.newState = (BlockState)this.stateToPlace.apply(entity, (Object)((BlockPos)pair.getFirst()), (Object)((BlockState)pair.getSecond()));
            return true;
        }
        return false;
    }

    protected void stop(E entity) {
        this.hasPlacedBlock = false;
        this.blockPos = null;
        this.newState = null;
    }

    protected boolean shouldKeepRunning(E entity) {
        return !this.hasPlacedBlock;
    }

    protected void start(ServerLevel level, E entity, long gameTime) {
        super.m_6735_(level, entity, gameTime);
        if (this.blockPos == null || this.newState == null) {
            OccultEngineering.LOGGER.info("Oops all null");
            return;
        }
        OccultEngineering.LOGGER.info("Starting placing block {}", (Object)this.newState);
        if (!this.hasPlacedBlock) {
            level.m_7731_(this.blockPos, this.newState, 3);
            this.hasPlacedBlock = true;
            this.m_22562_(level, (LivingEntity)entity, level.m_46467_());
        }
    }
}

