/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.pentacleschematics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.BlockTagRequirement;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class PentacleMaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public static final int MAX_ENTRIES_PER_CLIPBOARD_PAGE = 7;
    public Object2IntMap<Item> gathered = new Object2IntArrayMap();
    public Object2IntMap<Item> required = new Object2IntArrayMap();
    public Object2IntMap<Item> damageRequired = new Object2IntArrayMap();
    public Object2IntMap<GatheredTagItem> gatheredTag = new Object2IntArrayMap();
    public Object2IntMap<TagKey<Block>> requiredTag = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemRequirement.StackRequirement stack : requirement.getRequiredItems()) {
            if (stack instanceof BlockTagRequirement) {
                BlockTagRequirement btr = (BlockTagRequirement)stack;
                this.putOrIncrement(this.requiredTag, btr.tagKey);
                continue;
            }
            switch (stack.usage) {
                case DAMAGE: {
                    this.putOrIncrement((Object2IntMap)this.damageRequired, (Object)stack.stack);
                    break;
                }
                case CONSUME: {
                    this.putOrIncrement((Object2IntMap)this.required, (Object)stack.stack);
                }
            }
        }
    }

    public void clear() {
        this.damageRequired.clear();
        this.required.clear();
        this.gathered.clear();
        this.gatheredTag.clear();
        this.requiredTag.clear();
        this.blocksNotLoaded = false;
    }

    private void putOrIncrement(Object2IntMap<Item> map, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item == Items.f_41852_) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.m_41613_());
        } else {
            map.put((Object)item, stack.m_41613_());
        }
    }

    private <T> void putOrIncrement(Object2IntMap<T> map, @Nullable T item) {
        if (item == null) {
            return;
        }
        map.put(item, map.getOrDefault(item, 0) + 1);
    }

    private ObjectSet<Object2IntMap.Entry<GatheredTagItem>> getAllGatheredTag(TagKey<Block> tag) {
        return (ObjectSet)this.gatheredTag.object2IntEntrySet().stream().filter(i -> ((GatheredTagItem)i.getKey()).tag == tag).collect(Collectors.toCollection(ObjectOpenHashSet::new));
    }

    private ObjectSet<Object2IntMap.Entry<GatheredTagItem>> getAllGatheredTag(Item item) {
        return (ObjectSet)this.gatheredTag.object2IntEntrySet().stream().filter(i -> ((GatheredTagItem)i.getKey()).item == item).collect(Collectors.toCollection(ObjectOpenHashSet::new));
    }

    public void collect(ItemStack stack) {
        Item item = stack.m_41720_();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            this.gathered.put((Object)item, this.gathered.getOrDefault((Object)item, 0) + stack.m_41613_());
        } else {
            for (TagKey tag : this.requiredTag.keySet()) {
                if (!this.itemHasBlockTag(stack, (TagKey<Block>)tag)) continue;
                GatheredTagItem gatheredItem = new GatheredTagItem((TagKey<Block>)tag, stack.m_41720_());
                int value = this.gatheredTag.getOrDefault((Object)gatheredItem, 0);
                Integer matchingTagCount = this.gatheredTag.keySet().stream().filter(t -> t.item == stack.m_41720_()).map(i -> this.gatheredTag.getOrDefault(i, 0)).reduce(Integer::sum).orElse(0);
                if (matchingTagCount >= this.requiredTag.getInt((Object)tag)) continue;
                this.gatheredTag.put((Object)gatheredItem, value + stack.m_41613_());
                return;
            }
        }
    }

    private boolean itemHasBlockTag(ItemStack stack, TagKey<Block> tag) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        return block.m_49966_().m_204336_(tag);
    }

    public ItemStack createWrittenBook() {
        ItemStack book = new ItemStack((ItemLike)Items.f_42615_);
        CompoundTag tag = book.m_41784_();
        ListTag pages = new ListTag();
        MutableComponent textComponent = Component.m_237119_();
        if (this.blocksNotLoaded) {
            textComponent = Component.m_237113_((String)("\n" + String.valueOf(ChatFormatting.RED)));
            textComponent = textComponent.m_7220_((Component)CreateLang.translateDirect((String)"materialChecklist.blocksNotLoaded", (Object[])new Object[0]));
            pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
        }
        List<ChecklistEntry> checklistEntries = this.getChecklistEntries();
        int itemsWritten = 0;
        for (ChecklistEntry entry : checklistEntries) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.m_7220_((Component)Component.m_237113_((String)"\n >>>").m_130940_(entry.unfinished ? ChatFormatting.DARK_GRAY : ChatFormatting.DARK_GREEN));
                pages.add((Object)this.toBookPage((Component)textComponent));
                textComponent = Component.m_237119_();
            }
            ++itemsWritten;
            textComponent.m_7220_((Component)entry.format(true));
        }
        pages.add((Object)this.toBookPage((Component)textComponent));
        tag.m_128365_("pages", (Tag)pages);
        tag.m_128379_("readonly", true);
        tag.m_128359_("author", "P\u00facalith");
        tag.m_128359_("title", String.valueOf(ChatFormatting.BLUE) + "Material Checklist");
        textComponent = CreateLang.translateDirect((String)"materialChecklist", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131155_(Boolean.FALSE));
        book.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)textComponent));
        book.m_41751_(tag);
        return book;
    }

    private StringTag toBookPage(Component component) {
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component));
    }

    public ItemStack createWrittenClipboard() {
        ItemStack clipboard = AllBlocks.CLIPBOARD.asStack();
        CompoundTag tag = clipboard.m_41784_();
        ArrayList pages = new ArrayList();
        ArrayList<ClipboardEntry> currentPage = new ArrayList<ClipboardEntry>();
        if (this.blocksNotLoaded) {
            currentPage.add(new ClipboardEntry(false, CreateLang.translateDirect((String)"materialChecklist.blocksNotLoaded", (Object[])new Object[0]).m_130940_(ChatFormatting.RED)));
        }
        List<ChecklistEntry> checklistEntries = this.getChecklistEntries();
        int itemsWritten = 0;
        for (ChecklistEntry entry : checklistEntries) {
            if (itemsWritten == 7) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(!entry.unfinished, Component.m_237113_((String)">>>").m_130940_(entry.unfinished ? ChatFormatting.DARK_GRAY : ChatFormatting.DARK_GREEN)));
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            ++itemsWritten;
            currentPage.add(new ClipboardEntry(!entry.unfinished, entry.format(false)).displayItem(entry.item, 0));
        }
        pages.add(currentPage);
        ClipboardEntry.saveAll(pages, (ItemStack)clipboard);
        ClipboardOverrides.switchTo((ClipboardOverrides.ClipboardType)ClipboardOverrides.ClipboardType.WRITTEN, (ItemStack)clipboard);
        clipboard.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)CreateLang.translateDirect((String)"materialChecklist", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131155_(Boolean.FALSE))));
        tag.m_128379_("Readonly", true);
        clipboard.m_41751_(tag);
        return clipboard;
    }

    public List<ChecklistEntry> getChecklistEntries() {
        ArrayList allRequired = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        allRequired.sort((item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.m_41466_().getString().toLowerCase(locale);
            String name2 = item2.m_41466_().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        ArrayList<ChecklistEntry> checklistEntries = new ArrayList<ChecklistEntry>();
        ArrayList<Item> completedItem = new ArrayList<Item>();
        for (Item item : allRequired) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completedItem.add(item);
                continue;
            }
            checklistEntries.add(new ChecklistItemEntry(item, amount, true));
        }
        ArrayList<TagKey> completedTag = new ArrayList<TagKey>();
        for (TagKey blockTag : this.requiredTag.keySet()) {
            int amount = this.requiredTag.getInt((Object)blockTag);
            ObjectSet<Object2IntMap.Entry<GatheredTagItem>> gatheredOf = this.getAllGatheredTag((TagKey<Block>)blockTag);
            if (!gatheredOf.isEmpty()) {
                for (Object2IntMap.Entry entry : gatheredOf) {
                    amount -= entry.getIntValue();
                }
            }
            if (amount <= 0) {
                completedTag.add(blockTag);
                continue;
            }
            checklistEntries.add(new ChecklistTagEntry((TagKey<Block>)blockTag, this.getRepresentativeItem((TagKey<Block>)blockTag), amount, true));
        }
        for (Item item : completedItem) {
            checklistEntries.add(new ChecklistItemEntry(item, this.getRequiredAmount(item), false));
        }
        for (TagKey blockTag : completedTag) {
            checklistEntries.add(new ChecklistTagEntry((TagKey<Block>)blockTag, this.getRepresentativeItem((TagKey<Block>)blockTag), this.getRequiredAmount((TagKey<Block>)blockTag), false));
        }
        return checklistEntries;
    }

    public int getRequiredAmount(Item item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount += (int)Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new ItemStack((ItemLike)item).m_41776_());
        }
        return amount;
    }

    public int getRequiredAmount(TagKey<Block> blockTag) {
        return this.requiredTag.getOrDefault(blockTag, 0);
    }

    private ItemStack getRepresentativeItem(TagKey<Block> tag) {
        ImmutableList all = ImmutableList.copyOf((Iterable)BuiltInRegistries.f_256975_.m_206058_(tag));
        if (all.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)((Holder)all.get(0)).get());
    }

    public static class GatheredTagItem {
        public final TagKey<Block> tag;
        public final Item item;

        public GatheredTagItem(TagKey<Block> tag, Item stack) {
            this.tag = tag;
            this.item = stack;
        }
    }

    public static abstract class ChecklistEntry {
        public final ItemStack item;
        public final int amount;
        public boolean unfinished;

        private ChecklistEntry(ItemStack item, int amount, boolean unfinished) {
            this.unfinished = unfinished;
            this.item = item;
            this.amount = amount;
        }

        private int stackCount() {
            return this.amount / 64;
        }

        private int stackRemainder() {
            return this.amount % 64;
        }

        public MutableComponent format(boolean forBook) {
            MutableComponent tc = Component.m_237119_();
            tc.m_7220_((Component)this.getEntryName().m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this.item)))));
            if (!this.unfinished && forBook) {
                tc.m_130946_(" \u2714");
            }
            if (!this.unfinished || forBook) {
                tc.m_130940_(this.unfinished ? ChatFormatting.BLUE : ChatFormatting.DARK_GREEN);
            }
            return tc.m_7220_((Component)Component.m_237113_((String)("\n x" + this.amount)).m_130940_(ChatFormatting.BLACK)).m_7220_((Component)Component.m_237113_((String)(" | " + this.stackCount() + "\u25a4 +" + this.stackRemainder() + (forBook ? "\n" : ""))).m_130940_(ChatFormatting.GRAY));
        }

        @NotNull
        public abstract MutableComponent getEntryName();
    }

    private class ChecklistItemEntry
    extends ChecklistEntry {
        private ChecklistItemEntry(Item item, int amount, boolean unfinished) {
            this(new ItemStack((ItemLike)item), amount, unfinished);
        }

        private ChecklistItemEntry(ItemStack item, int amount, boolean unfinished) {
            super(item, amount, unfinished);
        }

        @Override
        @NotNull
        public MutableComponent getEntryName() {
            return Component.m_237115_((String)this.item.m_41778_());
        }
    }

    private class ChecklistTagEntry
    extends ChecklistEntry {
        TagKey<Block> tag;

        private ChecklistTagEntry(TagKey<Block> tag, Item item, int amount, boolean unfinished) {
            this(tag, new ItemStack((ItemLike)item), amount, unfinished);
        }

        private ChecklistTagEntry(TagKey<Block> tag, ItemStack item, int amount, boolean unfinished) {
            super(item, amount, unfinished);
            this.tag = tag;
        }

        @Override
        @NotNull
        public MutableComponent getEntryName() {
            ResourceLocation tl = this.tag.f_203868_();
            return Component.m_237113_((String)("Any #" + tl.m_135827_() + ":" + tl.m_135815_()));
        }
    }
}

