/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.phlogiport;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.irishgreencitrus.occultengineering.config.OccultEngineeringConfig;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.IPhlogiportNetworkable;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.PhlogiportLinkBehaviour;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.PhlogiportSignalParticle;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.PhlogiportSignalParticleData;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.packet.PhlogiportSendEffectPacket;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringPackets;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class PhlogiportBlockEntity
extends PackagePortBlockEntity {
    private PhlogiportLinkBehaviour link;
    private boolean inventoryFull = false;

    public PhlogiportBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.target = null;
    }

    private boolean shouldAcceptPackage() {
        return !this.inventoryFull;
    }

    public void filterChanged() {
        super.filterChanged();
        this.link.update(this.addressFilter, this.shouldAcceptPackage());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.link = new PhlogiportLinkBehaviour((SmartBlockEntity)this);
        behaviours.add(this.link);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.link.update(this.addressFilter, this.shouldAcceptPackage());
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.tryPullingFromBelow();
        this.trySendingPackage();
        this.tryPushingToBelow();
        this.sendData();
    }

    protected void trySendingPackage() {
        if (this.f_58857_ == null) {
            return;
        }
        boolean inventoryFull = true;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            BlockEntity be;
            IPhlogiportNetworkable matchingPort;
            String address;
            ItemStack stack = this.inventory.extractItem(i, 1, true);
            if (stack.m_41619_()) {
                inventoryFull = false;
                continue;
            }
            if (!PackageItem.isPackage((ItemStack)stack) || (address = PackageItem.getAddress((ItemStack)stack)).isEmpty() || Objects.equals(address, this.addressFilter) || (matchingPort = this.link.getMatchingPhlogiport(address)) == null || (be = this.f_58857_.m_7702_(matchingPort.getLocation())) == null || !(be instanceof PhlogiportBlockEntity)) continue;
            PhlogiportBlockEntity pbe = (PhlogiportBlockEntity)be;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)pbe.inventory, (ItemStack)stack, (boolean)false);
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            if (!remainder.m_41619_()) break;
            this.inventory.extractItem(i, 1, false);
            inventoryFull = false;
            int distance = this.f_58858_.m_123333_((Vec3i)pbe.f_58858_);
            Vec3 signalCenter = this.f_58858_.m_252807_().m_82549_(PhlogiportSignalParticle.offset);
            int receivePackageTimer = distance / 3;
            serverLevel.m_8767_((ParticleOptions)new PhlogiportSignalParticleData((PositionSource)new BlockPositionSource(pbe.m_58899_()), receivePackageTimer), signalCenter.m_7096_(), signalCenter.m_7098_(), signalCenter.m_7094_(), 1, 0.0, 0.0, 0.0, 1.0);
            OccultEngineeringPackets.sendToNear((Level)serverLevel, this.f_58858_, (Integer)OccultEngineeringConfig.server().phlogiportRangeBlocks.get(), (Object)new PhlogiportSendEffectPacket(this.f_58858_, false, true));
            OccultEngineeringPackets.sendToNear((Level)serverLevel, pbe.f_58858_, (Integer)OccultEngineeringConfig.server().phlogiportRangeBlocks.get(), (Object)new PhlogiportSendEffectPacket(pbe.f_58858_, true, true));
            this.f_58857_.m_151543_(this.f_58858_);
            this.f_58857_.m_151543_(pbe.f_58858_);
            break;
        }
        if (inventoryFull != this.inventoryFull) {
            this.inventoryFull = inventoryFull;
            this.link.update(this.addressFilter, this.shouldAcceptPackage());
        }
    }

    @Nullable
    protected IItemHandler getAdjacentInventory(Direction side) {
        assert (this.f_58857_ != null);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (blockEntity == null || blockEntity instanceof PhlogiportBlockEntity) {
            return null;
        }
        return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_()).orElse(null);
    }

    protected void tryPullingFromBelow() {
        if (this.inventoryFull) {
            return;
        }
        IItemHandler belowInventory = this.getAdjacentInventory(Direction.DOWN);
        if (belowInventory == null) {
            return;
        }
        ItemStack extract = ItemHelper.extract((IItemHandler)belowInventory, stack -> {
            if (!PackageItem.isPackage((ItemStack)stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || !PackageItem.matchAddress((ItemStack)stack, (String)filterString);
        }, (boolean)false);
        if (extract.m_41619_()) {
            return;
        }
        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)extract, (boolean)true);
        if (!leftover.m_41619_()) {
            return;
        }
        ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)extract, (boolean)false);
    }

    protected void tryPushingToBelow() {
        IItemHandler belowInventory = this.getAdjacentInventory(Direction.DOWN);
        if (belowInventory == null) {
            return;
        }
        ItemStack extract = ItemHelper.extract((IItemHandler)this.inventory, stack -> {
            if (!PackageItem.isPackage((ItemStack)stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || PackageItem.matchAddress((ItemStack)stack, (String)filterString);
        }, (boolean)false);
        if (extract.m_41619_()) {
            return;
        }
        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)belowInventory, (ItemStack)extract, (boolean)true);
        if (!leftover.m_41619_()) {
            return;
        }
        ItemHandlerHelper.insertItem((IItemHandler)belowInventory, (ItemStack)extract, (boolean)false);
    }

    protected void onOpenChange(boolean b) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playEffect(boolean isReceiver, boolean success) {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)this.f_58857_;
        Vec3 pos = Vec3.m_82512_((Vec3i)this.f_58858_);
        if (isReceiver) {
            AllSoundEvents.STOCK_LINK.playAt(this.f_58857_, pos, 0.5f, 2.0f, false);
            clientLevel.m_7106_((ParticleOptions)new WiFiParticle.Data(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.STOCK_LINK.playAt((Level)clientLevel, pos, 0.5f, 2.0f, false);
            clientLevel.m_7106_((ParticleOptions)new WiFiParticle.Data(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0, 1.0, 1.0);
        }
    }
}

