/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer.PulverizerBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PulverizerBlock
extends HorizontalKineticBlock
implements IBE<PulverizerBlockEntity> {
    private static final VoxelShaper SHAPE = new AllShapes.Builder(Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)13.0)).add(5.0, 2.0, 3.0, 11.0, 11.0, 10.0).forHorizontal(Direction.SOUTH);

    public PulverizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE.get((Direction)state.m_61143_(HORIZONTAL_FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)Objects.requireNonNullElseGet(preferred, () -> ((BlockPlaceContext)context).m_8125_()).m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean hasHandInteraction;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        PulverizerBlockEntity be = (PulverizerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be == null) {
            return InteractionResult.PASS;
        }
        boolean bl = hasHandInteraction = player.m_21120_(hand).m_41619_() || be.canProcess(player.m_21120_(hand));
        if (!hasHandInteraction) {
            return InteractionResult.PASS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, pulverizer -> {
            ItemStack mainHandItem = player.m_21120_(hand);
            if (mainHandItem.m_41619_()) {
                int slot;
                boolean outputEmpty = true;
                ItemStackHandler inv = pulverizer.outputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemStack stackInSlot = inv.getStackInSlot(slot);
                    if (!stackInSlot.m_41619_()) {
                        outputEmpty = false;
                    }
                    player.m_150109_().m_150079_(stackInSlot);
                    inv.setStackInSlot(slot, ItemStack.f_41583_);
                }
                if (outputEmpty) {
                    inv = pulverizer.inputInv;
                    for (slot = 0; slot < inv.getSlots(); ++slot) {
                        player.m_150109_().m_150079_(inv.getStackInSlot(slot));
                        inv.setStackInSlot(slot, ItemStack.f_41583_);
                    }
                }
            } else if (pulverizer.inputInv.getStackInSlot(0).m_41619_()) {
                player.m_21008_(hand, pulverizer.inputInv.insertItem(0, mainHandItem, false));
            }
            pulverizer.m_6596_();
            pulverizer.sendData();
        });
        return InteractionResult.SUCCESS;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_();
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<PulverizerBlockEntity> getBlockEntityClass() {
        return PulverizerBlockEntity.class;
    }

    public BlockEntityType<? extends PulverizerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)OccultEngineeringBlockEntities.MECHANICAL_PULVERIZER.get();
    }
}

