/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.OtherworldDetectorBlock;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.packet.ThirdEyeActivationPacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class OtherworldDetectorBlockEntity
extends SmartBlockEntity {
    public int turnOffInTicks = 0;
    public int comparatorSignalStrength = 0;

    public OtherworldDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.setLazyTickRate(20);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.turnOffInTicks > 0) {
            --this.turnOffInTicks;
            if (this.turnOffInTicks == 0) {
                this.deactivate();
            }
        }
        Vec3 centre = this.f_58858_.m_252807_();
        Player nearestPlayer = this.f_58857_.m_5788_(centre.f_82479_, centre.f_82480_, centre.f_82481_, 15.0, pl -> !pl.m_5833_());
        if (nearestPlayer == null) {
            return;
        }
        if (ThirdEyeActivationPacket.isActive(nearestPlayer)) {
            double distanceSqr = nearestPlayer.m_20275_(centre.f_82479_, centre.f_82480_, centre.f_82481_);
            double distance = Math.sqrt(distanceSqr);
            int newSignal = Math.max(0, 15 - (int)distance);
            this.activate(newSignal, 4);
        }
    }

    public void deactivate() {
        this.comparatorSignalStrength = 0;
        BlockState state = this.m_58900_();
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)OtherworldDetectorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }

    public void activate(int signalStrength, int ticks) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        this.turnOffInTicks = ticks;
        if (signalStrength != this.comparatorSignalStrength) {
            this.comparatorSignalStrength = signalStrength;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)OtherworldDetectorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128405_("turn_off_in", this.turnOffInTicks);
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.turnOffInTicks = tag.m_128451_("turn_off_in");
    }
}

