/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.entity.puca.brain;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public class SetWalkTargetAndWaitUntilReached<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED)});
    protected Function<E, BlockPos> targetSupplier;
    protected Function<E, Integer> timeoutSupplier;
    protected BiFunction<E, BlockPos, Float> speedMod = (owner, pos) -> Float.valueOf(1.0f);
    protected BiFunction<E, BlockPos, Integer> closeEnoughDist = (entity, pos) -> 2;
    protected BlockPos targetPosition = null;
    protected int timeoutTicks = 200;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetWalkTargetAndWaitUntilReached<E> target(Function<E, BlockPos> targetSupplier) {
        this.targetSupplier = targetSupplier;
        return this;
    }

    public SetWalkTargetAndWaitUntilReached<E> setTimeout(Function<E, Integer> timeoutSupplier) {
        this.timeoutSupplier = timeoutSupplier;
        return this;
    }

    public SetWalkTargetAndWaitUntilReached<E> speedMod(BiFunction<E, BlockPos, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public SetWalkTargetAndWaitUntilReached<E> closeEnoughWhen(BiFunction<E, BlockPos, Integer> function) {
        this.closeEnoughDist = function;
        return this;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        if (this.targetSupplier == null || this.timeoutSupplier == null) {
            return false;
        }
        BlockPos t = this.targetSupplier.apply(entity);
        if (t == null) {
            return false;
        }
        if (level.m_46749_(t)) {
            this.targetPosition = t;
        }
        return this.targetPosition != null;
    }

    protected void start(E entity) {
        if (this.targetPosition != null) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPosition, this.speedMod.apply(entity, this.targetPosition).floatValue(), this.closeEnoughDist.apply(entity, this.targetPosition).intValue()));
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetPosition));
        } else {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        }
    }

    protected boolean shouldKeepRunning(E entity) {
        if (this.timeoutTicks <= 0) {
            return false;
        }
        if (this.targetPosition == null || this.closeEnoughDist == null) {
            return true;
        }
        return entity.m_20182_().m_82557_(this.targetPosition.m_252807_()) > (double)this.closeEnoughDist.apply(entity, entity.m_20183_()).intValue();
    }

    protected void tick(E entity) {
        if (this.timeoutTicks > 0) {
            --this.timeoutTicks;
        }
    }

    protected void stop(E entity) {
        this.targetPosition = null;
    }
}

