/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.item;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.item.ModonomiconItem;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MechanicalGuideItem
extends ModonomiconItem {
    public static ResourceLocation ENCYCLOPEDIA_OF_SOULS = OccultEngineering.asResource("encyclopedia_of_souls");

    public MechanicalGuideItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            if (itemInHand.m_41782_()) {
                Book book = BookDataManager.get().getBook(ENCYCLOPEDIA_OF_SOULS);
                BookGuiManager.get().openBook(book.getId());
            } else {
                OccultEngineering.LOGGER.error("Encyclopedia of Souls: ItemStack has no tag!");
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)pLevel.f_46443_);
    }

    public Component m_7626_(ItemStack pStack) {
        Book book = BookDataManager.get().getBook(ENCYCLOPEDIA_OF_SOULS);
        if (book != null) {
            return Component.m_237115_((String)book.getName());
        }
        return super.m_7626_(pStack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Book book = BookDataManager.get().getBook(ENCYCLOPEDIA_OF_SOULS);
        if (book != null) {
            if (flagIn.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)"Book ID: ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)ENCYCLOPEDIA_OF_SOULS.toString()).m_130940_(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                tooltip.add((Component)Component.m_237115_((String)book.getTooltip()).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{stack.m_41782_() ? NbtUtils.m_178061_((Tag)((Tag)Objects.requireNonNull(stack.m_41783_()))) : Component.m_237113_((String)"{}")}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41784_().m_128359_("modonomicon:book_id", ENCYCLOPEDIA_OF_SOULS.toString());
        return super.initCapabilities(stack, nbt);
    }
}

