/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.phlogiport;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.IPhlogiportNetworkable;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.PhlogiportNetworkHandler;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PhlogiportLinkBehaviour
extends BlockEntityBehaviour
implements IPhlogiportNetworkable {
    public static final BehaviourType<PhlogiportLinkBehaviour> TYPE = new BehaviourType();
    boolean acceptsPackages;
    String address;

    public PhlogiportLinkBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public void update(String address, boolean acceptsPackages) {
        if (address == null || address.isBlank()) {
            return;
        }
        if (Objects.equals(this.address, address) && this.acceptsPackages == acceptsPackages) {
            return;
        }
        this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
        this.acceptsPackages = acceptsPackages;
        this.address = address;
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), this);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    @Override
    public boolean isReceiving() {
        return this.acceptsPackages;
    }

    @Override
    public boolean isFuelled() {
        return true;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().m_5776_()) {
            return;
        }
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), this);
    }

    public void unload() {
        super.unload();
        if (this.getWorld().m_5776_()) {
            return;
        }
        this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
    }

    @Nullable
    public IPhlogiportNetworkable getMatchingPhlogiport(String destinationAddress) {
        return this.getHandler().findMatchingPhlogiport((LevelAccessor)this.getWorld(), this, destinationAddress);
    }

    private PhlogiportNetworkHandler getHandler() {
        return OccultEngineering.PHLOGIPORT_NETWORK;
    }
}

