/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismTags;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PentacleProvider
implements DataProvider {
    private final Map<String, JsonElement> toSerialize = new HashMap<String, JsonElement>();
    private final DataGenerator generator;

    public PentacleProvider(DataGenerator generator) {
        this.generator = generator;
    }

    private void start() {
        this.addPentacle("craft_puca", this.createPattern("CW   WC", "W c c W", " c W c ", "  W0W  ", " c W c ", "W c c W", "CW   WC"), new MappingBuilder().candle().whiteChalk().copperChalk().chamber().ground().build());
    }

    private List<String> createPattern(String ... rows) {
        ArrayList<String> pattern = new ArrayList<String>();
        for (String row : rows) {
            pattern.add(row.replace(" ", "_"));
        }
        return pattern;
    }

    private void addPentacle(String name, List<String> pattern, Map<Character, JsonElement> mappings) {
        this.addPentacle(OccultEngineering.asResource(name), pattern, mappings);
    }

    private void addPentacle(ResourceLocation rl, List<String> pattern, Map<Character, JsonElement> mappings) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "modonomicon:dense");
        JsonArray outerPattern = PentacleProvider.createOuterPattern(pattern);
        json.add("pattern", (JsonElement)outerPattern);
        JsonObject jsonMapping = new JsonObject();
        for (Map.Entry<Character, JsonElement> entry : mappings.entrySet()) {
            jsonMapping.add(String.valueOf(entry.getKey()), entry.getValue());
        }
        json.add("mapping", (JsonElement)jsonMapping);
        this.toSerialize.put(rl.m_135815_(), (JsonElement)json);
    }

    @NotNull
    private static JsonArray createOuterPattern(List<String> pattern) {
        JsonArray outerPattern = new JsonArray();
        JsonArray innerPattern = new JsonArray();
        for (String row : pattern) {
            innerPattern.add(row);
        }
        outerPattern.add((JsonElement)innerPattern);
        JsonArray ground = new JsonArray();
        for (int i = 0; i < pattern.size(); ++i) {
            StringBuilder row = new StringBuilder();
            for (int j = 0; j < pattern.get(i).length(); ++j) {
                row.append((i + j) % 2 == 0 ? "*" : "+");
            }
            ground.add(row.toString());
        }
        outerPattern.add((JsonElement)ground);
        return outerPattern;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList futures = new ArrayList();
        Path folder = this.generator.getPackOutput().m_245114_();
        this.start();
        this.toSerialize.forEach((name, json) -> {
            Path path = folder.resolve("data/occultengineering/modonomicon/multiblocks/" + name + ".json");
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Pentacles: occultengineering";
    }

    private static class MappingBuilder {
        private final Map<Character, JsonElement> mappings = new HashMap<Character, JsonElement>();

        public MappingBuilder() {
            this.ground();
        }

        private MappingBuilder element(char c, JsonElement e) {
            this.mappings.put(Character.valueOf(c), e);
            return this;
        }

        private Map<Character, JsonElement> build() {
            return this.mappings;
        }

        private MappingBuilder block(char c, Supplier<? extends Block> b) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:block");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)b.get()).toString());
            return this.element(c, (JsonElement)json);
        }

        private MappingBuilder blockDisplay(char c, Supplier<? extends Block> b, Supplier<? extends Block> display) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:block");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)b.get()).toString());
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((Object)display.get()).toString());
            return this.element(c, (JsonElement)json);
        }

        private MappingBuilder display(char c, Supplier<? extends Block> display) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:display");
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((Object)display.get()).toString());
            return this.element(c, (JsonElement)json);
        }

        private MappingBuilder tag(char c, TagKey<Block> tag) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:tag");
            json.addProperty("tag", "#" + String.valueOf(tag.f_203868_()));
            return this.element(c, (JsonElement)json);
        }

        private MappingBuilder bowl() {
            return this.block('0', (Supplier<? extends Block>)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL);
        }

        private MappingBuilder chamber() {
            return this.block('0', (Supplier<? extends Block>)OccultEngineeringBlocks.MECHANICAL_CHAMBER);
        }

        private MappingBuilder copperChalk() {
            return this.block('c', (Supplier<? extends Block>)OccultEngineeringBlocks.COPPER_CHALK);
        }

        private MappingBuilder zincChalk() {
            return this.block('z', (Supplier<? extends Block>)OccultEngineeringBlocks.ZINC_CHALK);
        }

        private MappingBuilder brassChalk() {
            return this.block('b', (Supplier<? extends Block>)OccultEngineeringBlocks.BRASS_CHALK);
        }

        private MappingBuilder candle() {
            return this.tag('C', (TagKey<Block>)OccultismTags.Blocks.CANDLES);
        }

        private MappingBuilder whiteChalk() {
            return this.block('W', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_WHITE);
        }

        private MappingBuilder goldChalk() {
            return this.block('G', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_GOLD);
        }

        private MappingBuilder purpleChalk() {
            return this.block('P', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_PURPLE);
        }

        private MappingBuilder redChalk() {
            return this.block('R', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_RED);
        }

        private MappingBuilder crystal() {
            return this.block('S', (Supplier<? extends Block>)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL);
        }

        private MappingBuilder skeleton() {
            return this.block('Z', () -> Blocks.f_50310_);
        }

        private MappingBuilder ground() {
            return this.display('*', (Supplier<? extends Block>)OccultismBlocks.OTHERSTONE).display('+', () -> Blocks.f_50069_);
        }

        private MappingBuilder wither() {
            return this.block('N', () -> Blocks.f_50312_);
        }
    }
}

