/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen.recipe;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.datagen.recipe.OcEngRecipeProvider;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlocks;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OcEngStandardRecipeGen
extends OcEngRecipeProvider {
    String currentFolder = "";
    OcEngRecipeProvider.GeneratedRecipe ENCYCLOPEDIA_OF_SOULS = this.create((ItemProviderEntry<? extends ItemLike>)OccultEngineeringItems.ENCYCLOPEDIA_OF_SOULS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((RegistryObject)OccultismItems.DICTIONARY_OF_SPIRITS).get())).viaShapeless(b -> b.m_126209_(() -> ((RegistryObject)OccultismItems.DICTIONARY_OF_SPIRITS).get()).m_126209_((ItemLike)AllBlocks.COGWHEEL));
    OcEngRecipeProvider.GeneratedRecipe STERLING_SILVER_COMPACTING = this.metalCompacting((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(OccultEngineeringItems.STERLING_SILVER_NUGGET, OccultEngineeringItems.STERLING_SILVER_INGOT, OccultEngineeringBlocks.STERLING_SILVER_BLOCK), (List<Supplier<TagKey<Item>>>)ImmutableList.of(OcEngRecipeProvider.I::sterlingNugget, OcEngRecipeProvider.I::sterlingIngot, OcEngRecipeProvider.I::sterlingBlock));
    OcEngRecipeProvider.GeneratedRecipe COMBINED_GOGGLES = this.create((ItemProviderEntry<? extends ItemLike>)OccultEngineeringItems.COMBINED_GOGGLES).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.GOGGLES).get())).viaShapeless(b -> b.m_126209_(() -> ((RegistryObject)OccultismItems.OTHERWORLD_GOGGLES).get()).m_126209_((ItemLike)AllItems.GOGGLES));

    public OcEngStandardRecipeGen(PackOutput output) {
        super(output);
    }

    OcEngRecipeProvider.Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new OcEngRecipeProvider.Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    OcEngRecipeProvider.GeneratedRecipe createSpecial(Supplier<? extends SimpleCraftingRecipeSerializer<?>> serializer, String recipeType, String path) {
        ResourceLocation location = this.currentFolder == null || this.currentFolder.isEmpty() ? OccultEngineering.asResource(recipeType + "/" + path) : OccultEngineering.asResource(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)serializer.get()));
            b.m_126359_(consumer, location.toString());
        });
    }

    OcEngRecipeProvider.GeneratedRecipe blastCrushedMetal(Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix("_from_crushed").viaCooking(ingredient).rewardXP(0.1f).inBlastFurnace();
    }

    OcEngRecipeProvider.GeneratedRecipe recycleGlass(BlockEntry<? extends Block> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> Blocks.f_50058_)).withSuffix("_from_" + ingredient.getId().m_135815_()).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).forDuration(50).inFurnace();
    }

    OcEngRecipeProvider.GeneratedRecipe recycleGlassPane(BlockEntry<? extends Block> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> Blocks.f_50185_)).withSuffix("_from_" + ingredient.getId().m_135815_()).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).forDuration(50).inFurnace();
    }

    OcEngRecipeProvider.GeneratedRecipe metalCompacting(List<ItemProviderEntry<? extends ItemLike>> variants, List<Supplier<TagKey<Item>>> ingredients) {
        OcEngRecipeProvider.GeneratedRecipe result = null;
        int i = 0;
        while (i + 1 < variants.size()) {
            ItemProviderEntry<? extends ItemLike> currentEntry = variants.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = variants.get(i + 1);
            Supplier<TagKey<Item>> currentIngredient = ingredients.get(i);
            Supplier<TagKey<Item>> nextIngredient = ingredients.get(i + 1);
            this.create(nextEntry).withSuffix("_from_compacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShaped(b -> b.m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), (TagKey)currentIngredient.get()));
            result = this.create(currentEntry).returns(9).withSuffix("_from_decompacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> nextEntry.get())).viaShapeless(b -> b.m_206419_((TagKey)nextIngredient.get()));
            ++i;
        }
        return result;
    }

    OcEngRecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends ItemLike>> cycle) {
        OcEngRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShapeless(b -> b.m_126209_((ItemLike)currentEntry.get()));
        }
        return result;
    }

    OcEngRecipeProvider.GeneratedRecipe clearData(ItemProviderEntry<? extends ItemLike> item) {
        return this.create(item).withSuffix("_clear").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item.get())).viaShapeless(b -> b.m_126209_((ItemLike)item.get()));
    }

    class GeneratedRecipeBuilder {
        List<ICondition> recipeConditions;
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        OcEngRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return OcEngStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)OcEngStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        OcEngRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return OcEngStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)OcEngStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(result -> consumer.accept(!this.recipeConditions.isEmpty() ? new ConditionSupportingShapelessRecipeResult((FinishedRecipe)result, this.recipeConditions) : result), this.createLocation("crafting"));
            });
        }

        OcEngRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return OcEngStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).m_5456_());
                b.m_266439_("has_item", (CriterionTriggerInstance)OcEngStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)base.get()}).m_45077_()}));
                b.m_266371_(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return OccultEngineering.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            if (StringUtils.isBlank((CharSequence)this.path)) {
                return OccultEngineering.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
            }
            return OccultEngineering.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;
            private float exp;
            private int cookingTime;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            OcEngRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            OcEngRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            OcEngRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            OcEngRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            OcEngRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            OcEngRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private OcEngRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return OcEngStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)OcEngStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((FinishedRecipe)result, GeneratedRecipeBuilder.this.compatDatagenOutput, GeneratedRecipeBuilder.this.recipeConditions) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
                });
            }
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    private record ConditionSupportingShapelessRecipeResult(FinishedRecipe wrapped, List<ICondition> conditions) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(@NotNull JsonObject pJson) {
            this.wrapped.m_7917_(pJson);
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            pJson.add("conditions", (JsonElement)conds);
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    private record ModdedCookingRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, List<ICondition> conditions) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(JsonObject object) {
            this.wrapped.m_7917_(object);
            object.addProperty("result", this.outputOverride.toString());
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            object.add("conditions", (JsonElement)conds);
        }
    }
}

