/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.registry;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.packet.ThirdEyeActivationPacket;
import io.github.irishgreencitrus.occultengineering.content.item.combinedgoggles.ToggleCombinedGogglesPacket;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.packet.PentacleAltarConfirmPacket;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.packet.PucalithSendOptionPacket;
import io.github.irishgreencitrus.occultengineering.content.phlogiport.packet.PhlogiportSendEffectPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public enum OccultEngineeringPackets {
    PENTACLE_ALTAR_CONFIRM(PentacleAltarConfirmPacket.class, PentacleAltarConfirmPacket::new, NetworkDirection.PLAY_TO_SERVER),
    PUCALITH_SEND_OPTION(PucalithSendOptionPacket.class, PucalithSendOptionPacket::new, NetworkDirection.PLAY_TO_SERVER),
    THIRD_EYE_ACTIVATION(ThirdEyeActivationPacket.class, ThirdEyeActivationPacket::new, NetworkDirection.PLAY_TO_SERVER),
    TOGGLE_COMBINED_GOGGLES(ToggleCombinedGogglesPacket.class, ToggleCombinedGogglesPacket::new, NetworkDirection.PLAY_TO_SERVER),
    PHLOGIPORT_SEND_EFFECT(PhlogiportSendEffectPacket.class, PhlogiportSendEffectPacket::new, NetworkDirection.PLAY_TO_CLIENT);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 1;
    public static final String NETWORK_VERSION_STR;
    private final PacketType<?> packetType;
    private static SimpleChannel channel;

    private <T extends SimplePacketBase> OccultEngineeringPackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection networkDirection) {
        this.packetType = new PacketType<T>(type, factory, networkDirection);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (OccultEngineeringPackets packet : OccultEngineeringPackets.values()) {
            packet.packetType.register();
        }
    }

    public static void sendToNear(Level world, BlockPos pos, int range, Object message) {
        OccultEngineeringPackets.getChannel().send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), message);
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    static {
        CHANNEL_NAME = OccultEngineering.asResource("main");
        NETWORK_VERSION_STR = String.valueOf(1);
    }

    private static class PacketType<T extends SimplePacketBase> {
        private static int index = 0;
        private final BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private final Function<FriendlyByteBuf, T> decoder;
        private final BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private final Class<T> type;
        private final NetworkDirection direction;

        private PacketType(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            OccultEngineeringPackets.getChannel().messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerNetworkThread(this.handler).add();
        }
    }
}

