/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.compat.curios;

import com.simibubi.create.content.equipment.goggles.GogglesItem;
import io.github.irishgreencitrus.occultengineering.compat.curios.OcEngCuriosRenderers;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.IEventBus;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class OcEngCurios {
    private static Optional<Map<String, ICurioStacksHandler>> resolveCuriosMap(LivingEntity entity) {
        return Optional.ofNullable((ICuriosItemHandler)entity.getCapability(CuriosCapability.INVENTORY)).map(ICuriosItemHandler::getCurios);
    }

    public static void init(IEventBus modEventBus) {
        GogglesItem.addIsWearingPredicate(player -> OcEngCurios.resolveCuriosMap((LivingEntity)player).map(curiosMap -> {
            for (ICurioStacksHandler stacksHandler : curiosMap.values()) {
                int slots = stacksHandler.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    if (!OccultEngineeringItems.COMBINED_GOGGLES.isIn(stacksHandler.getStacks().getStackInSlot(slot))) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false));
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> modEventBus.addListener(OcEngCuriosRenderers::onLayerRegister));
    }
}

