/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.pentacleschematics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.BlockTagRequirement;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class PentacleMaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public static final int MAX_ENTRIES_PER_CLIPBOARD_PAGE = 7;
    public Object2IntMap<Item> gathered = new Object2IntArrayMap();
    public Object2IntMap<Item> required = new Object2IntArrayMap();
    public Object2IntMap<Item> damageRequired = new Object2IntArrayMap();
    public Object2IntMap<GatheredTagItem> gatheredTag = new Object2IntArrayMap();
    public Object2IntMap<TagKey<Block>> requiredTag = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemRequirement.StackRequirement stack : requirement.getRequiredItems()) {
            if (stack instanceof BlockTagRequirement) {
                BlockTagRequirement btr = (BlockTagRequirement)stack;
                this.putOrIncrement(this.requiredTag, btr.tagKey);
                continue;
            }
            switch (stack.usage) {
                case DAMAGE: {
                    this.putOrIncrement((Object2IntMap)this.damageRequired, (Object)stack.stack);
                    break;
                }
                case CONSUME: {
                    this.putOrIncrement((Object2IntMap)this.required, (Object)stack.stack);
                }
            }
        }
    }

    public void clear() {
        this.damageRequired.clear();
        this.required.clear();
        this.gathered.clear();
        this.gatheredTag.clear();
        this.requiredTag.clear();
        this.blocksNotLoaded = false;
    }

    private void putOrIncrement(Object2IntMap<Item> map, ItemStack stack) {
        Item item = stack.getItem();
        if (item == Items.AIR) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.getCount());
        } else {
            map.put((Object)item, stack.getCount());
        }
    }

    private <T> void putOrIncrement(Object2IntMap<T> map, @Nullable T item) {
        if (item == null) {
            return;
        }
        map.put(item, map.getOrDefault(item, 0) + 1);
    }

    private ObjectSet<Object2IntMap.Entry<GatheredTagItem>> getAllGatheredTag(TagKey<Block> tag) {
        return (ObjectSet)this.gatheredTag.object2IntEntrySet().stream().filter(i -> ((GatheredTagItem)i.getKey()).tag == tag).collect(Collectors.toCollection(ObjectOpenHashSet::new));
    }

    private ObjectSet<Object2IntMap.Entry<GatheredTagItem>> getAllGatheredTag(Item item) {
        return (ObjectSet)this.gatheredTag.object2IntEntrySet().stream().filter(i -> ((GatheredTagItem)i.getKey()).item == item).collect(Collectors.toCollection(ObjectOpenHashSet::new));
    }

    public void collect(ItemStack stack) {
        Item item = stack.getItem();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            this.gathered.put((Object)item, this.gathered.getOrDefault((Object)item, 0) + stack.getCount());
        } else {
            for (TagKey tag : this.requiredTag.keySet()) {
                if (!this.itemHasBlockTag(stack, (TagKey<Block>)tag)) continue;
                GatheredTagItem gatheredItem = new GatheredTagItem((TagKey<Block>)tag, stack.getItem());
                int value = this.gatheredTag.getOrDefault((Object)gatheredItem, 0);
                Integer matchingTagCount = this.gatheredTag.keySet().stream().filter(t -> t.item == stack.getItem()).map(i -> this.gatheredTag.getOrDefault(i, 0)).reduce(Integer::sum).orElse(0);
                if (matchingTagCount >= this.requiredTag.getInt((Object)tag)) continue;
                this.gatheredTag.put((Object)gatheredItem, value + stack.getCount());
                return;
            }
        }
    }

    private boolean itemHasBlockTag(ItemStack stack, TagKey<Block> tag) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        return block.defaultBlockState().is(tag);
    }

    public ItemStack createWrittenBook() {
        ItemStack book = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
        ArrayList<Filterable> pages = new ArrayList<Filterable>();
        MutableComponent textComponent = Component.empty();
        if (this.blocksNotLoaded) {
            textComponent = Component.literal((String)("\n" + String.valueOf(ChatFormatting.RED)));
            textComponent = textComponent.append((Component)CreateLang.translateDirect((String)"materialChecklist.blocksNotLoaded", (Object[])new Object[0]));
            pages.add(Filterable.passThrough((Object)textComponent));
        }
        List<ChecklistEntry> checklistEntries = this.getChecklistEntries();
        int itemsWritten = 0;
        for (ChecklistEntry entry : checklistEntries) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.append((Component)Component.literal((String)"\n >>>").withStyle(entry.unfinished ? ChatFormatting.DARK_GRAY : ChatFormatting.DARK_GREEN));
                pages.add(Filterable.passThrough((Object)textComponent));
                textComponent = Component.empty();
            }
            ++itemsWritten;
            textComponent.append((Component)entry.format(true));
        }
        pages.add(Filterable.passThrough((Object)textComponent));
        WrittenBookContent contents = new WrittenBookContent(Filterable.passThrough((Object)(String.valueOf(ChatFormatting.BLUE) + "Material Checklist")), "P\u00facalith", 0, pages, true);
        book.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)contents);
        textComponent = CreateLang.translateDirect((String)"materialChecklist", (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withItalic(Boolean.FALSE));
        book.set(DataComponents.CUSTOM_NAME, (Object)textComponent);
        return book;
    }

    public ItemStack createWrittenClipboard() {
        ItemStack clipboard = AllBlocks.CLIPBOARD.asStack();
        ArrayList pages = new ArrayList();
        ArrayList<ClipboardEntry> currentPage = new ArrayList<ClipboardEntry>();
        if (this.blocksNotLoaded) {
            currentPage.add(new ClipboardEntry(false, CreateLang.translateDirect((String)"materialChecklist.blocksNotLoaded", (Object[])new Object[0]).withStyle(ChatFormatting.RED)));
        }
        List<ChecklistEntry> checklistEntries = this.getChecklistEntries();
        int itemsWritten = 0;
        for (ChecklistEntry entry : checklistEntries) {
            if (itemsWritten == 7) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(!entry.unfinished, Component.literal((String)">>>").withStyle(entry.unfinished ? ChatFormatting.DARK_GRAY : ChatFormatting.DARK_GREEN)));
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            ++itemsWritten;
            currentPage.add(new ClipboardEntry(!entry.unfinished, entry.format(false)).displayItem(entry.item, 0));
        }
        pages.add(currentPage);
        ClipboardEntry.saveAll(pages, (ItemStack)clipboard);
        ClipboardOverrides.switchTo((ClipboardOverrides.ClipboardType)ClipboardOverrides.ClipboardType.WRITTEN, (ItemStack)clipboard);
        clipboard.set(DataComponents.CUSTOM_NAME, (Object)CreateLang.translateDirect((String)"materialChecklist", (Object[])new Object[0]).setStyle(Style.EMPTY.withItalic(Boolean.FALSE)));
        clipboard.set(AllDataComponents.CLIPBOARD_READ_ONLY, (Object)Unit.INSTANCE);
        return clipboard;
    }

    public List<ChecklistEntry> getChecklistEntries() {
        ArrayList allRequired = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        allRequired.sort((item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.getDescription().getString().toLowerCase(locale);
            String name2 = item2.getDescription().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        ArrayList<ChecklistEntry> checklistEntries = new ArrayList<ChecklistEntry>();
        ArrayList<Item> completedItem = new ArrayList<Item>();
        for (Item item : allRequired) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completedItem.add(item);
                continue;
            }
            checklistEntries.add(new ChecklistItemEntry(this, item, amount, true));
        }
        ArrayList<TagKey> completedTag = new ArrayList<TagKey>();
        for (TagKey blockTag : this.requiredTag.keySet()) {
            int amount = this.requiredTag.getInt((Object)blockTag);
            ObjectSet<Object2IntMap.Entry<GatheredTagItem>> gatheredOf = this.getAllGatheredTag((TagKey<Block>)blockTag);
            if (!gatheredOf.isEmpty()) {
                for (Object2IntMap.Entry entry : gatheredOf) {
                    amount -= entry.getIntValue();
                }
            }
            if (amount <= 0) {
                completedTag.add(blockTag);
                continue;
            }
            checklistEntries.add(new ChecklistTagEntry(this, (TagKey<Block>)blockTag, this.getRepresentativeItem((TagKey<Block>)blockTag), amount, true));
        }
        for (Item item : completedItem) {
            checklistEntries.add(new ChecklistItemEntry(this, item, this.getRequiredAmount(item), false));
        }
        for (TagKey blockTag : completedTag) {
            checklistEntries.add(new ChecklistTagEntry(this, (TagKey<Block>)blockTag, this.getRepresentativeItem((TagKey<Block>)blockTag), this.getRequiredAmount((TagKey<Block>)blockTag), false));
        }
        return checklistEntries;
    }

    public int getRequiredAmount(Item item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount += (int)Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new ItemStack((ItemLike)item).getMaxDamage());
        }
        return amount;
    }

    public int getRequiredAmount(TagKey<Block> blockTag) {
        return this.requiredTag.getOrDefault(blockTag, 0);
    }

    private ItemStack getRepresentativeItem(TagKey<Block> tag) {
        ImmutableList all = ImmutableList.copyOf((Iterable)BuiltInRegistries.BLOCK.getTagOrEmpty(tag));
        if (all.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)((Holder)all.getFirst()).value());
    }

    public record GatheredTagItem(TagKey<Block> tag, Item item) {
    }

    public static abstract class ChecklistEntry {
        public final ItemStack item;
        public final int amount;
        public boolean unfinished;

        private ChecklistEntry(ItemStack item, int amount, boolean unfinished) {
            this.unfinished = unfinished;
            this.item = item;
            this.amount = amount;
        }

        private int stackCount() {
            return this.amount / 64;
        }

        private int stackRemainder() {
            return this.amount % 64;
        }

        public MutableComponent format(boolean forBook) {
            MutableComponent tc = Component.empty();
            tc.append((Component)this.getEntryName().setStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(this.item)))));
            if (!this.unfinished && forBook) {
                tc.append(" \u2714");
            }
            if (!this.unfinished || forBook) {
                tc.withStyle(this.unfinished ? ChatFormatting.BLUE : ChatFormatting.DARK_GREEN);
            }
            return tc.append((Component)Component.literal((String)("\n x" + this.amount)).withStyle(ChatFormatting.BLACK)).append((Component)Component.literal((String)(" | " + this.stackCount() + "\u25a4 +" + this.stackRemainder() + (forBook ? "\n" : ""))).withStyle(ChatFormatting.GRAY));
        }

        @NotNull
        public abstract MutableComponent getEntryName();
    }

    private class ChecklistItemEntry
    extends ChecklistEntry {
        private ChecklistItemEntry(PentacleMaterialChecklist pentacleMaterialChecklist, Item item, int amount, boolean unfinished) {
            this(pentacleMaterialChecklist, new ItemStack((ItemLike)item), amount, unfinished);
        }

        private ChecklistItemEntry(PentacleMaterialChecklist pentacleMaterialChecklist, ItemStack item, int amount, boolean unfinished) {
            super(item, amount, unfinished);
        }

        @Override
        @NotNull
        public MutableComponent getEntryName() {
            return Component.translatable((String)this.item.getDescriptionId());
        }
    }

    private class ChecklistTagEntry
    extends ChecklistEntry {
        TagKey<Block> tag;

        private ChecklistTagEntry(PentacleMaterialChecklist pentacleMaterialChecklist, TagKey<Block> tag, Item item, int amount, boolean unfinished) {
            this(pentacleMaterialChecklist, tag, new ItemStack((ItemLike)item), amount, unfinished);
        }

        private ChecklistTagEntry(PentacleMaterialChecklist pentacleMaterialChecklist, TagKey<Block> tag, ItemStack item, int amount, boolean unfinished) {
            super(item, amount, unfinished);
            this.tag = tag;
        }

        @Override
        @NotNull
        public MutableComponent getEntryName() {
            ResourceLocation tl = this.tag.location();
            return Component.literal((String)("Any #" + tl.getNamespace() + ":" + tl.getPath()));
        }
    }
}

