/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookTrueConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PentaclesCategory
extends CategoryProvider {
    public static final String CATEGORY_ID = "pentacles";

    public PentaclesCategory(ModonomiconProviderBase parent) {
        super(parent);
    }

    protected String[] generateEntryMap() {
        return new String[]{"____O_p__"};
    }

    protected void generateEntries() {
        BookEntryModel overview = this.add(this.makeOverviewEntry(this.entryMap, 'O'));
        BookEntryModel craftPuca = this.add(this.makeCraftPucaEntry(this.entryMap, 'p'));
        craftPuca.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        craftPuca.withCondition((BookConditionModel)BookTrueConditionModel.create());
    }

    protected String categoryName() {
        return "Pentacles";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)OccultismItems.PENTACLE_CRAFT.get()));
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    private BookEntryModel makeOverviewEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "overview";
        this.context().entry(entryId);
        this.lang().add(this.context().entryName(), "Overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle("Pentacles").withText("This section contains the list of Pentacles added by Occult Engineering.\n\\\nEach Pentacle in this section requires the use of the Mechanical Chamber, and will not work\nwith the Golden Sacrificial Bowl.\n\\\nOther than that, the Pentacles work the same way as in Occultism.\n");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withIcon((ItemLike)Items.BOOK).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makeCraftPucaEntry(CategoryEntryMap entryMap, char icon) {
        String entryId = "craft_puca";
        this.context().entry(entryId);
        this.context().page("intro");
        this.lang().add(this.context().entryName(), "Fionnt\u00e1n's Uncompromising Captivation");
        this.lang().add(this.context().entryDescription(), "The first of the mechanical rituals.");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Fionnt\u00e1n's Uncompromising Captivation");
        this.lang().add(this.context().pageText(), "**Purpose:** Bind P\u00faca\n\\\n\\\nFionnt\u00e1n's Uncompromising Captivation is a pentacle for binding P\u00faca into blocks and items which can be used for simple automation. It is suitable to permanently infuse machinery.");
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc(entryId));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Uses");
        this.lang().add(this.context().pageText(), "Craft Otherworld Detector");
        return BookEntryModel.create((ResourceLocation)this.fullyQualifiedEntryId(), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.PENTACLE_CRAFT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private ResourceLocation fullyQualifiedEntryId() {
        return this.modLoc(this.categoryId() + "/" + this.context().entryId());
    }
}

