/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.command;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class MultiblockCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"multiblock").requires(cs -> cs.hasPermission(2) && cs.isPlayer())).then(Commands.literal((String)"place").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"location", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> MultiblockCommand.run((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"location"), (Level)((CommandSourceStack)ctx.getSource()).getLevel())))));
    }

    private static int run(CommandContext<CommandSourceStack> ctx, ResourceLocation location, BlockPos blockPos, Level level) {
        Multiblock multiblock = MultiblockDataManager.get().getMultiblock(location);
        if (multiblock == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.occultengineering.multiblock.not_found", (Object[])new Object[]{location}));
            return 0;
        }
        try {
            multiblock.place(level, blockPos, Rotation.NONE);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.occultengineering.multiblock.success"), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.occultengineering.multiblock.failure"));
            return 0;
        }
    }
}

